/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.XmlAttributeLiteralEscaper;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueImpl
extends XmlElementImpl
implements XmlAttributeValue,
PsiLanguageInjectionHost,
RegExpLanguageHost,
PsiMetaOwner,
PsiMetaData,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance(XmlAttributeValueImpl.class);

    public XmlAttributeValueImpl() {
        super(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttributeValue(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public String getValue() {
        ASTNode endQuote;
        String text2 = this.getText();
        ASTNode startQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
        if (startQuote != null) {
            text2 = StringUtil.trimStart((String)text2, (String)startQuote.getText());
        }
        if ((endQuote = this.findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER)) != null) {
            text2 = StringUtil.trimEnd((String)text2, (String)endQuote.getText());
        }
        String string2 = text2;
        if (string2 == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public TextRange getValueTextRange() {
        TextRange range = this.getTextRange();
        String value2 = this.getValue();
        if (value2.isEmpty()) {
            return range;
        }
        int start2 = range.getStartOffset() + this.getText().indexOf(value2);
        int end = start2 + value2.length();
        return new TextRange(start2, end);
    }

    public PsiReference @NotNull [] getReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(2);
        }
        PsiReference[] psiReferences = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)hints);
        Integer offset = hints.offsetInElement;
        if (offset != null) {
            PsiReference[] psiReferenceArray = PsiDynaReference.filterByOffset((PsiReference[])psiReferences, (int)offset);
            if (psiReferenceArray == null) {
                XmlAttributeValueImpl.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (psiReferences == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(4);
        }
        return psiReferences;
    }

    public boolean shouldAskParentForReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(5);
        }
        return false;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    public boolean isValidHost() {
        return this.getParent() instanceof XmlAttribute;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(7);
        }
        try {
            String quoteChar = this.getTextLength() > 0 ? this.getText().substring(0, 1) : "";
            String contents = StringUtil.containsAnyChar((String)quoteChar, (String)"'\"") ? StringUtil.trimEnd((String)StringUtil.trimStart((String)text2, (String)quoteChar), (String)quoteChar) : text2;
            XmlAttribute newAttribute = XmlElementFactory.getInstance(this.getProject()).createAttribute(StringUtil.defaultIfEmpty(this.getParent() instanceof XmlAttribute ? ((XmlAttribute)this.getParent()).getName() : null, (String)"q"), contents, this);
            XmlAttributeValue newValue = newAttribute.getValueElement();
            CheckUtil.checkWritable((PsiElement)this);
            this.replaceAllChildrenToChildrenOf(newValue.getNode());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<XmlAttributeValueImpl> createLiteralTextEscaper() {
        return new XmlAttributeLiteralEscaper(this);
    }

    public PsiMetaData getMetaData() {
        return this;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getValue();
    }

    public String getName() {
        return this.getValue();
    }

    public void init(PsiElement element) {
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentationWithSeparator(){

            public String getPresentableText() {
                return XmlAttributeValueImpl.this.getText();
            }

            public String getLocationString() {
                return SymbolPresentationUtil.getFilePathPresentation((PsiFile)XmlAttributeValueImpl.this.getContainingFile());
            }

            public Icon getIcon(boolean open2) {
                return null;
            }
        };
    }

    @Override
    public boolean characterNeedsEscaping(char c, boolean isInClass) {
        return c == ']' || c == '}';
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group2) {
        return true;
    }

    @Override
    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return true;
    }

    @Override
    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            XmlAttributeValueImpl.$$$reportNull$$$0(8);
        }
        if (category.startsWith("Is")) {
            try {
                return Character.UnicodeBlock.forName(category.substring(2)) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (String[] name : DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties()) {
            if (!name[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] @NotNull [] getAllKnownProperties() {
        return DefaultRegExpPropertiesProvider.getInstance().getAllKnownProperties();
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return DefaultRegExpPropertiesProvider.getInstance().getPropertyDescription(name);
    }

    @Override
    public String[] @NotNull [] getKnownCharacterClasses() {
        return DefaultRegExpPropertiesProvider.getInstance().getKnownCharacterClasses();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeValueImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4, 6 -> new IllegalStateException(string2);
        };
    }
}

