/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private Collection<DetectedVcsRoot> myDetectedRoots;
    @NotNull
    private final Object LOCK;

    VcsRootDetectorImpl(@NotNull Project project2) {
        if (project2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<VcsRoot> detect() {
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("VcsRootDetectorImpl.detect");
        Object object = this.LOCK;
        // MONITORENTER : object
        Activity activity2 = StartUpMeasurer.startActivity((String)"VcsRootDetector.detect", (ActivityCategory)ActivityCategory.DEFAULT);
        Collection<VcsRoot> roots = this.scanForRootsInContentRoots();
        activity2.end();
        this.myDetectedRoots = ContainerUtil.map(roots, DetectedVcsRoot::new);
        Collection<VcsRoot> collection = roots;
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(1);
        return collection;
    }

    @Override
    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("VcsRootDetectorImpl.detect root", new Object[]{startDir});
        if (startDir == null || !startDir.isInLocalFileSystem()) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        Set<VcsRoot> set = Collections.unmodifiableSet(this.scanForDirectory(startDir));
        if (set == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<VcsRoot> getOrDetect() {
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("VcsRootDetectorImpl.getOrDetect");
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myDetectedRoots != null) {
            List list = ContainerUtil.mapNotNull(this.myDetectedRoots, it -> it.toVcsRoot(this.myProject));
            // MONITOREXIT : object
            if (list != null) return list;
            VcsRootDetectorImpl.$$$reportNull$$$0(4);
            return list;
        }
        Collection<VcsRoot> collection = this.detect();
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(5);
        return collection;
    }

    @NotNull
    private Set<VcsRoot> scanForDirectory(@NotNull VirtualFile dirToScan) {
        if (dirToScan == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(6);
        }
        if (!VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            Set<VcsRoot> set = Collections.emptySet();
            if (set == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>();
        HashMap<VirtualFile, Boolean> scannedDirs = new HashMap<VirtualFile, Boolean>();
        detectedRoots.addAll(this.scanForRootsInsideDir(this.myProject, dirToScan, null, scannedDirs));
        detectedRoots.addAll(this.scanForRootsAboveDirs(Collections.singletonList(dirToScan), scannedDirs, detectedRoots));
        HashSet<VcsRoot> hashSet = detectedRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsInContentRoots() {
        if (this.myProject.isDisposed() || !VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List contentRoots = ContainerUtil.sorted(DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots(), Comparator.comparing(root -> root.getPath().length()));
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("VcsRootDetectorImpl.scanForRootsInContentRoots - contentRoots", new Object[]{contentRoots});
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>();
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        HashMap<VirtualFile, Boolean> scannedDirs = new HashMap<VirtualFile, Boolean>();
        for (VirtualFile dir : ContainerUtil.reverse((List)contentRoots)) {
            detectedRoots.addAll(this.scanForRootsInsideDir(this.myProject, dir, skipDirs, scannedDirs));
            skipDirs.add(dir);
        }
        detectedRoots.addAll(this.scanForRootsAboveDirs(contentRoots, scannedDirs, detectedRoots));
        detectedRoots.addAll(this.scanDependentRoots(scannedDirs, detectedRoots));
        HashSet<VcsRoot> hashSet = detectedRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull Project project2, @NotNull VirtualFile root, @Nullable Set<? extends VirtualFile> skipDirs, @NotNull Map<VirtualFile, Boolean> scannedDirs) {
        if (project2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(11);
        }
        if (root == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(12);
        }
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(13);
        }
        HashSet<VcsRoot> result2 = new HashSet<VcsRoot>();
        VcsRootScanner.visitDirsRecursivelyWithoutExcluded(project2, root, false, (Function1<? super VirtualFile, VirtualFileVisitor.Result>)((Function1)dir -> {
            if (skipDirs != null && skipDirs.contains(dir)) {
                return VirtualFileVisitor.SKIP_CHILDREN;
            }
            if (scannedDirs.containsKey(dir)) {
                return VirtualFileVisitor.CONTINUE;
            }
            VcsRoot vcsRoot = this.getVcsRootFor((VirtualFile)dir, null);
            scannedDirs.put((VirtualFile)dir, vcsRoot != null);
            if (vcsRoot != null) {
                LOG.debug("Found VCS ", new Object[]{vcsRoot.getVcs(), " in ", vcsRoot.getPath(), " under ", root});
                result2.add(vcsRoot);
            }
            return VirtualFileVisitor.CONTINUE;
        }));
        HashSet<VcsRoot> hashSet = result2;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsAboveDirs(@NotNull Collection<? extends VirtualFile> dirsToScan, @NotNull Map<VirtualFile, Boolean> scannedDirs, @NotNull Collection<VcsRoot> detectedRoots) {
        if (dirsToScan == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(15);
        }
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(16);
        }
        if (detectedRoots == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(17);
        }
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        for (VcsRoot root : detectedRoots) {
            skipDirs.add(root.getPath());
        }
        ContainerUtil.addIfNotNull(skipDirs, (Object)VfsUtil.getUserHomeDir());
        HashSet<VcsRoot> result2 = new HashSet<VcsRoot>();
        for (VirtualFile virtualFile : dirsToScan) {
            this.scanForRootsAboveDir(virtualFile, scannedDirs, skipDirs, result2);
        }
        HashSet<VcsRoot> hashSet = result2;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    private void scanForRootsAboveDir(@NotNull VirtualFile root, @NotNull Map<VirtualFile, Boolean> scannedDirs, @NotNull Set<? super VirtualFile> skipDirs, @NotNull Set<? super VcsRoot> result2) {
        VirtualFile parent;
        Pattern ignorePattern;
        if (root == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(19);
        }
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(20);
        }
        if (skipDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(22);
        }
        if (VcsRootScanner.isUnderIgnoredDirectory(this.myProject, ignorePattern = VcsRootScanner.parseDirIgnorePattern(), root)) {
            return;
        }
        VirtualFile virtualFile = parent = root.isDirectory() ? root : root.getParent();
        while (parent != null) {
            if (!skipDirs.add((VirtualFile)parent)) {
                return;
            }
            if (scannedDirs.get(parent) == Boolean.TRUE) {
                return;
            }
            if (!scannedDirs.containsKey(parent)) {
                VcsRoot vcsRoot = this.getVcsRootFor(parent, root);
                scannedDirs.put(parent, vcsRoot != null);
                if (vcsRoot != null) {
                    LOG.debug("Found VCS ", new Object[]{vcsRoot.getVcs(), " in ", vcsRoot.getPath(), " above ", root});
                    result2.add(vcsRoot);
                    return;
                }
            }
            parent = parent.getParent();
        }
    }

    @NotNull
    private Collection<VcsRoot> scanDependentRoots(@NotNull Map<VirtualFile, Boolean> scannedDirs, @NotNull Collection<VcsRoot> detectedRoots) {
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(23);
        }
        if (detectedRoots == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(24);
        }
        HashSet<VcsRoot> result2 = new HashSet<VcsRoot>();
        for (VcsRoot root : detectedRoots) {
            VcsRootChecker rootChecker = (VcsRootChecker)VcsRootChecker.EXTENSION_POINT_NAME.findFirstSafe(checker -> root.getVcs() != null && Objects.equals(checker.getSupportedVcs(), root.getVcs().getKeyInstanceMethod()));
            if (rootChecker == null) continue;
            List<VirtualFile> dependentRoots = rootChecker.suggestDependentRoots(root.getPath());
            for (VirtualFile dependentRoot : dependentRoots) {
                if (scannedDirs.containsKey(dependentRoot)) continue;
                VcsRoot vcsRoot = this.detectVcsRootBy(dependentRoot, null, rootChecker);
                scannedDirs.put(dependentRoot, vcsRoot != null);
                if (vcsRoot == null) continue;
                LOG.debug("Found VCS ", new Object[]{vcsRoot.getVcs(), " in ", vcsRoot.getPath(), "dependent on", root});
                result2.add(vcsRoot);
            }
        }
        if (!result2.isEmpty()) {
            result2.addAll(this.scanDependentRoots(scannedDirs, result2));
        }
        HashSet<VcsRoot> hashSet = result2;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    @Nullable
    private VcsRoot getVcsRootFor(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore) {
        if (maybeRoot == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(26);
        }
        ProgressManager.checkCanceled();
        return (VcsRoot)VcsRootChecker.EXTENSION_POINT_NAME.computeSafeIfAny(checker -> this.detectVcsRootBy(maybeRoot, dirToCheckForIgnore, (VcsRootChecker)checker));
    }

    @Nullable
    private VcsRoot detectVcsRootBy(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore, @NotNull VcsRootChecker checker) {
        if (maybeRoot == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(27);
        }
        if (checker == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(28);
        }
        if (!maybeRoot.isInLocalFileSystem()) {
            return null;
        }
        if (!checker.isRoot(maybeRoot)) {
            return null;
        }
        if (dirToCheckForIgnore != null && checker.isIgnored(maybeRoot, dirToCheckForIgnore)) {
            return null;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance(this.myProject).findVcsByName(checker.getSupportedVcs().getName());
        if (vcs == null) {
            return null;
        }
        return new VcsRoot(vcs, maybeRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 14, 18, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirToScan";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scannedDirs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToScan";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipDirs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeRoot";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInContentRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInsideDir";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsAboveDirs";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "scanDependentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scanForDirectory";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsInsideDir";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsAboveDirs";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsAboveDir";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "scanDependentRoots";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootFor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "detectVcsRootBy";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 14, 18, 25 -> new IllegalStateException(string2);
        };
    }

    private static final class DetectedVcsRoot {
        @Nullable
        private final String myVcsName;
        @NotNull
        private final VirtualFile myPath;

        private DetectedVcsRoot(@NotNull VcsRoot root) {
            if (root == null) {
                DetectedVcsRoot.$$$reportNull$$$0(0);
            }
            AbstractVcs vcs = root.getVcs();
            this.myVcsName = vcs != null ? vcs.getName() : null;
            this.myPath = root.getPath();
        }

        @Nullable
        public VcsRoot toVcsRoot(@NotNull Project project2) {
            if (project2 == null) {
                DetectedVcsRoot.$$$reportNull$$$0(1);
            }
            if (this.myVcsName == null) {
                return null;
            }
            AbstractVcs vcs = AllVcses.getInstance(project2).getByName(this.myVcsName);
            return vcs != null ? new VcsRoot(vcs, this.myPath) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl$DetectedVcsRoot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toVcsRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

