/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingChangesPanel
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LoadingChangesPanel.class);
    @Nullable
    private final StatusText myEmptyText;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    private ProgressIndicator myIndicator;

    public LoadingChangesPanel(@NotNull JComponent panel2, @Nullable StatusText emptyText, @NotNull Disposable disposable) {
        if (panel2 == null) {
            LoadingChangesPanel.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            LoadingChangesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myEmptyText = emptyText;
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposable);
        this.myLoadingPanel.add((Component)panel2, (Object)"Center");
        this.add((Component)this.myLoadingPanel, "Center");
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    @RequiresEdt
    public <T> void loadChangesInBackground(@NotNull ThrowableComputable<? extends T, ? extends VcsException> loadChanges, @NotNull Consumer<@Nullable T> applyResult) {
        if (loadChanges == null) {
            LoadingChangesPanel.$$$reportNull$$$0(2);
        }
        if (applyResult == null) {
            LoadingChangesPanel.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
        this.myIndicator = BackgroundTaskUtil.executeAndTryWait(indicator -> this.doLoadChanges(loadChanges, applyResult), this::startLoadingProgress);
    }

    protected void startLoadingProgress() {
        this.myLoadingPanel.startLoading();
        if (this.myEmptyText != null) {
            this.myEmptyText.setText("");
        }
    }

    @NotNull
    private <T> Runnable doLoadChanges(@NotNull ThrowableComputable<? extends T, ? extends VcsException> loadChanges, @NotNull Consumer<@Nullable T> applyResult) {
        Runnable runnable;
        if (loadChanges == null) {
            LoadingChangesPanel.$$$reportNull$$$0(4);
        }
        if (applyResult == null) {
            LoadingChangesPanel.$$$reportNull$$$0(5);
        }
        try {
            Object changes = loadChanges.compute();
            runnable = () -> {
                this.myLoadingPanel.stopLoading();
                if (this.myEmptyText != null) {
                    this.myEmptyText.setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
                }
                applyResult.accept(changes);
            };
        }
        catch (ProcessCanceledException e) {
            Runnable runnable2 = EmptyRunnable.INSTANCE;
            if (runnable2 == null) {
                LoadingChangesPanel.$$$reportNull$$$0(7);
            }
            return runnable2;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Runnable runnable3 = () -> {
                this.myLoadingPanel.stopLoading();
                if (this.myEmptyText != null) {
                    this.myEmptyText.setText(StringUtilRt.notNullize((String)e.getMessage(), (String)VcsBundle.message("changes.cant.load.changes", new Object[0])), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
                applyResult.accept(null);
            };
            if (runnable3 == null) {
                LoadingChangesPanel.$$$reportNull$$$0(8);
            }
            return runnable3;
        }
        if (runnable == null) {
            LoadingChangesPanel.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    public void dispose() {
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadChanges";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/browser/LoadingChangesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/browser/LoadingChangesPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesInBackground";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doLoadChanges";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

