/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.branch.BranchStateProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u001c\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u00062\u0006\u0010#\u001a\u00020\u0002J\b\u0010$\u001a\u00020!H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020!H\u0002R7\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent;", "Lcom/intellij/ui/components/JBLabel;", "Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "pathsProvider", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lkotlin/jvm/functions/Function0;)V", "<set-?>", "", "Lcom/intellij/vcs/branch/BranchData;", "branches", "getBranches", "()Ljava/util/Set;", "setBranches", "(Ljava/util/Set;)V", "branches$delegate", "Lkotlin/properties/ReadWriteProperty;", "changeEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Ljavax/swing/event/ChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isGroupedByRepository", "", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addChangeListener", "", "block", "parent", "dispose", "getPreferredSize", "Ljava/awt/Dimension;", "refresh", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCurrentBranchComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentBranchComponent.kt\ncom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n33#2,3:119\n1603#3,9:122\n1855#3:131\n1856#3:133\n1612#3:134\n1#4:132\n*S KotlinDebug\n*F\n+ 1 CurrentBranchComponent.kt\ncom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent\n*L\n37#1:119,3\n82#1:122,9\n82#1:131\n82#1:133\n82#1:134\n82#1:132\n*E\n"})
public final class CurrentBranchComponent
extends JBLabel
implements Disposable {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final Function0<Iterable<FilePath>> pathsProvider;
    @NotNull
    private final EventDispatcher<ChangeListener> changeEventDispatcher;
    @NotNull
    private final ReadWriteProperty branches$delegate;
    @NotNull
    private static final JBColor BACKGROUND_BASE_COLOR;
    @JvmField
    @NotNull
    public static final JBColor TEXT_COLOR;

    /*
     * WARNING - void declaration
     */
    public CurrentBranchComponent(@NotNull ChangesTree tree2, @NotNull Function0<? extends Iterable<? extends FilePath>> pathsProvider) {
        void initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter(pathsProvider, (String)"pathsProvider");
        this.tree = tree2;
        this.pathsProvider = pathsProvider;
        EventDispatcher eventDispatcher = EventDispatcher.create(ChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(ChangeListener::class.java)");
        this.changeEventDispatcher = eventDispatcher;
        Delegates delegates = Delegates.INSTANCE;
        Set set = SetsKt.emptySet();
        boolean $i$f$observable = false;
        this.branches$delegate = (ReadWriteProperty)new ObservableProperty<Set<? extends BranchData>>((Object)initialValue$iv, this){
            final /* synthetic */ CurrentBranchComponent this$0;
            {
                this.this$0 = currentBranchComponent;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property2, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Set set = (Set)newValue;
                Set oldValue2 = (Set)oldValue;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldValue2, (Object)newValue2)) {
                    this.this$0.setText(BranchPresentation.INSTANCE.getText((Collection)newValue2));
                    this.this$0.setToolTipText(BranchPresentation.INSTANCE.getTooltip((Collection)newValue2));
                    this.this$0.setVisible(!((Collection)newValue2).isEmpty());
                    ((ChangeListener)CurrentBranchComponent.access$getChangeEventDispatcher$p(this.this$0).getMulticaster()).stateChanged(new ChangeEvent((Object)((Object)this.this$0)));
                }
            }
        };
        this.setVisible(false);
        this.setIcon(AllIcons.Vcs.Branch);
        this.setForeground((Color)TEXT_COLOR);
        PropertyChangeListener treeChangeListener = arg_0 -> CurrentBranchComponent._init_$lambda$1(this, arg_0);
        this.tree.addPropertyChangeListener(treeChangeListener);
        Disposer.register((Disposable)this, () -> CurrentBranchComponent._init_$lambda$2(this, treeChangeListener));
        this.refresh();
    }

    private final Set<BranchData> getBranches() {
        return (Set)this.branches$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setBranches(Set<? extends BranchData> set) {
        this.branches$delegate.setValue((Object)this, $$delegatedProperties[0], set);
    }

    private final boolean isGroupedByRepository() {
        ChangesGroupingSupport changesGroupingSupport = this.tree.getGroupingSupport();
        Intrinsics.checkNotNullExpressionValue((Object)changesGroupingSupport, (String)"tree.groupingSupport");
        ChangesGroupingSupport groupingSupport = changesGroupingSupport;
        return groupingSupport.isAvailable("repository") && groupingSupport.get("repository");
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"tree.project");
        return project2;
    }

    public final void addChangeListener(@NotNull Function0<Unit> block, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.changeEventDispatcher.addListener(arg_0 -> CurrentBranchComponent.addChangeListener$lambda$3(block, arg_0), parent);
    }

    @Nullable
    public Dimension getPreferredSize() {
        return this.isVisible() ? super.getPreferredSize() : (Dimension)JBUI.emptySize();
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final void refresh() {
        Set set;
        boolean needShowBranch = !this.isGroupedByRepository();
        CurrentBranchComponent currentBranchComponent = this;
        if (needShowBranch) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = (Iterable)this.pathsProvider.invoke();
            CurrentBranchComponent currentBranchComponent2 = currentBranchComponent;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BranchData it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                FilePath it = (FilePath)element$iv$iv;
                boolean bl2 = false;
                if (Companion.getCurrentBranch(this.getProject(), it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            currentBranchComponent = currentBranchComponent2;
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        currentBranchComponent.setBranches(set);
    }

    private static final void _init_$lambda$1(CurrentBranchComponent this$0, PropertyChangeEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"model")) {
            this$0.refresh();
        }
    }

    private static final void _init_$lambda$2(CurrentBranchComponent this$0, PropertyChangeListener $treeChangeListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$treeChangeListener, (String)"$treeChangeListener");
        this$0.tree.removePropertyChangeListener($treeChangeListener);
    }

    private static final void addChangeListener$lambda$3(Function0 $block, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        $block.invoke();
    }

    @JvmStatic
    @NotNull
    public static final Color getBranchPresentationBackground(@NotNull Color background) {
        return Companion.getBranchPresentationBackground(background);
    }

    public static final /* synthetic */ EventDispatcher access$getChangeEventDispatcher$p(CurrentBranchComponent $this) {
        return $this.changeEventDispatcher;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(CurrentBranchComponent.class, "branches", "getBranches()Ljava/util/Set;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.RefLabel.backgroundBase", (Color)((Color)new JBColor(Color.BLACK, Color.WHITE)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"VersionContr\u2026olor.BLACK, Color.WHITE))");
        BACKGROUND_BASE_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"VersionControl.RefLabel.foreground", (Color)((Color)new JBColor(new Color(0x7A7A7A), new Color(0x909090))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(\"VersionContr\u2026a7a7a), Color(0x909090)))");
        TEXT_COLOR = jBColor2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\t2\u0006\u0010\r\u001a\u00020\fH\u0007J\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent$Companion;", "", "()V", "BACKGROUND_BALANCE", "", "getBACKGROUND_BALANCE", "()D", "BACKGROUND_BASE_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "TEXT_COLOR", "getBranchPresentationBackground", "Ljava/awt/Color;", "background", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProviders", "", "Lcom/intellij/vcs/branch/BranchStateProvider;", "kotlin.jvm.PlatformType", "namedDouble", "name", "", "default", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final double getBACKGROUND_BALANCE() {
            return this.namedDouble("VersionControl.RefLabel.backgroundBrightness", 0.08);
        }

        private final double namedDouble(String name, double d) {
            double d2;
            Object value2 = UIManager.get(name);
            if (value2 instanceof Double) {
                d2 = ((Number)value2).doubleValue();
            } else if (value2 instanceof Integer) {
                d2 = ((Number)value2).intValue();
            } else if (value2 instanceof String) {
                Double d3 = StringsKt.toDoubleOrNull((String)((String)value2));
                d2 = d3 != null ? d3 : d;
            } else {
                d2 = d;
            }
            return d2;
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project2, @NotNull Change change) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            FilePath filePath = ChangesUtil.getFilePath(change);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(change)");
            return this.getCurrentBranch(project2, filePath);
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project2, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FilePath filePath = VcsUtil.getFilePath(file);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(file)");
            return this.getCurrentBranch(project2, filePath);
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project2, @NotNull FilePath path2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return (BranchData)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getProviders(project2)), (Function1)((Function1)new Function1<BranchStateProvider, BranchData>(path2){
                final /* synthetic */ FilePath $path;
                {
                    this.$path = $path;
                    super(1);
                }

                @Nullable
                public final BranchData invoke(BranchStateProvider it) {
                    return it.getCurrentBranch(this.$path);
                }
            })));
        }

        @JvmStatic
        @NotNull
        public final Color getBranchPresentationBackground(@NotNull Color background) {
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Color color = ColorUtil.mix((Color)background, (Color)((Color)BACKGROUND_BASE_COLOR), (double)this.getBACKGROUND_BALANCE());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"mix(background, BACKGROU\u2026OLOR, BACKGROUND_BALANCE)");
            return color;
        }

        private final List<BranchStateProvider> getProviders(Project project2) {
            return BranchStateProvider.EP_NAME.getExtensionList((AreaInstance)project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

