/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddList
implements ChangeListCommand {
    @NotNull
    private final String myName;
    @Nullable
    private final String myComment;
    @Nullable
    private final ChangeListData myData;
    private boolean myWasListCreated;
    private LocalChangeList myNewListCopy;
    private String myOldComment;

    public AddList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data2) {
        if (name == null) {
            AddList.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myComment = comment;
        this.myData = data2;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList list = worker.getChangeListByName(this.myName);
        if (list == null) {
            String id = this.myNewListCopy != null ? this.myNewListCopy.getId() : null;
            this.myWasListCreated = true;
            this.myOldComment = null;
            this.myNewListCopy = worker.addChangeList(this.myName, this.myComment, id, this.myData);
        } else if (StringUtil.isNotEmpty((String)this.myComment)) {
            this.myWasListCreated = false;
            this.myOldComment = worker.editComment(this.myName, this.myComment);
            this.myNewListCopy = worker.getChangeListByName(this.myName);
        } else {
            this.myWasListCreated = false;
            this.myOldComment = null;
            this.myNewListCopy = list;
        }
    }

    @Override
    public void doNotify(ChangeListListener listener2) {
        if (this.myWasListCreated) {
            listener2.changeListAdded(this.myNewListCopy);
        } else if (this.myNewListCopy != null && this.myOldComment != null) {
            listener2.changeListCommentChanged(this.myNewListCopy, this.myOldComment);
        }
    }

    @Nullable
    public LocalChangeList getNewListCopy() {
        return this.myNewListCopy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/local/AddList", "<init>"));
    }
}

