/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.tools.combined.CombinedBlockId;
import com.intellij.diff.tools.combined.CombinedDiffModel;
import com.intellij.diff.tools.combined.CombinedDiffModelImpl;
import com.intellij.diff.tools.combined.CombinedDiffModelRepository;
import com.intellij.diff.tools.combined.CombinedDiffRegistry;
import com.intellij.diff.tools.combined.CombinedDiffVirtualFile;
import com.intellij.diff.tools.combined.CombinedPathBlockId;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/ShowCombinedDiffAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.platform.vcs.impl"})
public final class ShowCombinedDiffAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project2 = e.getProject();
        e.getPresentation().setEnabledAndVisible(CombinedDiffRegistry.INSTANCE.isEnabled() && project2 != null && changes != null && changes.length > 1);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        Object object = e.getRequiredData(VcsDataKeys.CHANGES);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(VcsDataKeys.CHANGES)");
        Object[] changes = (Change[])object;
        Companion.showDiff(project3, ArraysKt.toList((Object[])changes));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/ShowCombinedDiffAction$Companion;", "", "()V", "showDiff", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nShowCombinedDiffAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowCombinedDiffAction.kt\ncom/intellij/openapi/vcs/changes/actions/diff/ShowCombinedDiffAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,56:1\n1603#2,9:57\n1855#2:66\n1856#2:68\n1612#2:69\n1194#2,2:70\n1222#2,4:72\n1#3:67\n29#4,3:76\n*S KotlinDebug\n*F\n+ 1 ShowCombinedDiffAction.kt\ncom/intellij/openapi/vcs/changes/actions/diff/ShowCombinedDiffAction$Companion\n*L\n40#1:57,9\n40#1:66\n40#1:68\n40#1:69\n44#1:70,2\n44#1:72,4\n40#1:67\n48#1:76,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void showDiff(@NotNull Project project2, @NotNull List<? extends Change> changes) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            Iterable $this$mapNotNull$iv = changes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChangeDiffRequestProducer it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Change it = (Change)element$iv$iv;
                boolean bl2 = false;
                Map changeContext = new LinkedHashMap();
                VcsDiffUtil.putFilePathsIntoChangeContext(it, changeContext);
                if (ChangeDiffRequestProducer.create(project2, it, changeContext) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                element$iv$iv$iv = (ChangeDiffRequestProducer)element$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl = false;
                FilePath filePath = it.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"it.filePath");
                FileStatus fileStatus = it.getFileStatus();
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"it.fileStatus");
                map2.put((CombinedBlockId)new CombinedPathBlockId(filePath, fileStatus, null, 4, null), element$iv$iv);
            }
            Map producers = destination$iv$iv2;
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            String sourceId = string2;
            CombinedDiffModelImpl model2 = new CombinedDiffModelImpl(project2, null, 2, null);
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<CombinedDiffModelRepository> serviceClass$iv = CombinedDiffModelRepository.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            ((CombinedDiffModelRepository)object).registerModel(sourceId, (CombinedDiffModel)model2);
            model2.setBlocks(producers);
            String string3 = VcsBundle.message("changes.combined.diff", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"changes.combined.diff\")");
            CombinedDiffVirtualFile allInOneDiffFile = new CombinedDiffVirtualFile(sourceId, string3, null, 4, null);
            DiffEditorTabFilesManager.Companion.getInstance(project2).showDiffFile((VirtualFile)allInOneDiffFile, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

