/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsLogAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        selection.requestFullDetails(details -> {
            MultiMap grouped = this.groupCommits(project2, (Collection)details, VcsShortCommitDetails::getRoot);
            if (grouped == null) {
                return;
            }
            this.actionPerformed(project2, grouped);
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(2);
        }
        Project project2 = e.getProject();
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (project2 == null || selection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MultiMap<Repo, Hash> grouped = this.groupFirstPackOfCommits(project2, selection);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project2, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, Hash> var1);

    protected boolean isVisible(@NotNull Project project2, @NotNull MultiMap<Repo, Hash> grouped) {
        if (project2 == null) {
            VcsLogAction.$$$reportNull$$$0(3);
        }
        if (grouped == null) {
            VcsLogAction.$$$reportNull$$$0(4);
        }
        AbstractRepositoryManager<Repo> manager = this.getRepositoryManager(project2);
        return grouped.keySet().stream().noneMatch(manager::isExternal);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, Hash> groupFirstPackOfCommits(@NotNull Project project2, @NotNull VcsLogCommitSelection selection) {
        MultiMap commitIds;
        if (project2 == null) {
            VcsLogAction.$$$reportNull$$$0(5);
        }
        if (selection == null) {
            VcsLogAction.$$$reportNull$$$0(6);
        }
        if ((commitIds = this.groupCommits(project2, ContainerUtil.getFirstItems(selection.getCommits(), (int)1000), CommitId::getRoot)) == null) {
            return null;
        }
        MultiMap hashes2 = MultiMap.create();
        for (Map.Entry entry2 : commitIds.entrySet()) {
            hashes2.putValues((Object)((Repository)entry2.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)entry2.getValue()), CommitId::getHash));
        }
        return hashes2;
    }

    @Nullable
    private <T> MultiMap<Repo, T> groupCommits(@NotNull Project project2, @NotNull Collection<? extends T> commits2, @NotNull Function<? super T, ? extends VirtualFile> rootGetter) {
        if (project2 == null) {
            VcsLogAction.$$$reportNull$$$0(7);
        }
        if (commits2 == null) {
            VcsLogAction.$$$reportNull$$$0(8);
        }
        if (rootGetter == null) {
            VcsLogAction.$$$reportNull$$$0(9);
        }
        MultiMap map2 = MultiMap.create();
        for (T commit2 : commits2) {
            Repo root = this.getRepositoryForRoot(project2, (VirtualFile)rootGetter.fun(commit2));
            if (root == null) {
                return null;
            }
            map2.putValue(root, commit2);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/VcsLogAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/VcsLogAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupFirstPackOfCommits";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "groupCommits";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string2);
        };
    }
}

