/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dvcs/branch/DvcsBranchSyncPolicyUpdateNotifier;", "Repo", "Lcom/intellij/dvcs/repo/Repository;", "", "project", "Lcom/intellij/openapi/project/Project;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "dvcsSyncSettings", "Lcom/intellij/dvcs/branch/DvcsSyncSettings;", "repositoryManager", "Lcom/intellij/dvcs/repo/AbstractRepositoryManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/AbstractVcs;Lcom/intellij/dvcs/branch/DvcsSyncSettings;Lcom/intellij/dvcs/repo/AbstractRepositoryManager;)V", "initBranchSyncPolicyIfNotInitialized", "", "notifyAboutSyncedBranches", "intellij.platform.vcs.dvcs.impl"})
public final class DvcsBranchSyncPolicyUpdateNotifier<Repo extends Repository> {
    @NotNull
    private final Project project;
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final DvcsSyncSettings dvcsSyncSettings;
    @NotNull
    private final AbstractRepositoryManager<Repo> repositoryManager;

    public DvcsBranchSyncPolicyUpdateNotifier(@NotNull Project project2, @NotNull AbstractVcs vcs, @NotNull DvcsSyncSettings dvcsSyncSettings, @NotNull AbstractRepositoryManager<Repo> repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)dvcsSyncSettings, (String)"dvcsSyncSettings");
        Intrinsics.checkNotNullParameter(repositoryManager, (String)"repositoryManager");
        this.project = project2;
        this.vcs = vcs;
        this.dvcsSyncSettings = dvcsSyncSettings;
        this.repositoryManager = repositoryManager;
    }

    public final void initBranchSyncPolicyIfNotInitialized() {
        if (this.repositoryManager.moreThanOneRoot() && this.dvcsSyncSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (this.repositoryManager.shouldProposeSyncControl()) {
                this.notifyAboutSyncedBranches();
                this.dvcsSyncSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.dvcsSyncSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    private final void notifyAboutSyncedBranches() {
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(this.project);
        String string2 = DvcsBundle.message("notification.message.branch.operations.are.executed.on.all.roots", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"notification.me\u2026e.executed.on.all.roots\")");
        vcsNotifier.notify(VcsNotifier.STANDARD_NOTIFICATION.createNotification(string2, NotificationType.INFORMATION).setDisplayId("vcs.branch.operations.are.executed.on.all.roots").addAction((AnAction)NotificationAction.create((String)DvcsBundle.message("action.NotificationAction.DvcsBranchPopup.text.disable", new Object[0]), (arg_0, arg_1) -> DvcsBranchSyncPolicyUpdateNotifier.notifyAboutSyncedBranches$lambda$0((Function2)new Function2<AnActionEvent, Notification, Unit>(this){
            final /* synthetic */ DvcsBranchSyncPolicyUpdateNotifier<Repo> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable AnActionEvent anActionEvent, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                ShowSettingsUtil.getInstance().showSettingsDialog(DvcsBranchSyncPolicyUpdateNotifier.access$getProject$p(this.this$0), DvcsBranchSyncPolicyUpdateNotifier.access$getVcs$p(this.this$0).getDisplayName());
                if (DvcsBranchSyncPolicyUpdateNotifier.access$getDvcsSyncSettings$p(this.this$0).getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
                    notification.expire();
                }
            }
        }, arg_0, arg_1))));
    }

    private static final void notifyAboutSyncedBranches$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Project access$getProject$p(DvcsBranchSyncPolicyUpdateNotifier $this) {
        return $this.project;
    }

    public static final /* synthetic */ AbstractVcs access$getVcs$p(DvcsBranchSyncPolicyUpdateNotifier $this) {
        return $this.vcs;
    }

    public static final /* synthetic */ DvcsSyncSettings access$getDvcsSyncSettings$p(DvcsBranchSyncPolicyUpdateNotifier $this) {
        return $this.dvcsSyncSettings;
    }
}

