/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.psi.XmlPsiBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddXsiSchemaLocationForExtResourceAction
extends BaseExtResourceAction {
    @NonNls
    private static final String XMLNS_XSI_ATTR_NAME = "xmlns:xsi";
    @NonNls
    private static final String XSI_SCHEMA_LOCATION_ATTR_NAME = "xsi:schemaLocation";
    private static final String KEY = "xml.intention.add.xsi.schema.location.for.external.resource";

    @Override
    protected String getQuickFixKeyId() {
        return KEY;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            AddXsiSchemaLocationForExtResourceAction.$$$reportNull$$$0(0);
        }
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doInvoke(final @NotNull PsiFile file, int offset, final @NotNull String uri, final Editor editor) throws IncorrectOperationException {
        XmlTag tag;
        if (file == null) {
            AddXsiSchemaLocationForExtResourceAction.$$$reportNull$$$0(1);
        }
        if (uri == null) {
            AddXsiSchemaLocationForExtResourceAction.$$$reportNull$$$0(2);
        }
        if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), XmlTag.class)) == null) {
            return;
        }
        final ArrayList schemaLocations = new ArrayList();
        CreateNSDeclarationIntentionFix.processExternalUris(new CreateNSDeclarationIntentionFix.TagMetaHandler(tag.getLocalName()), file, new CreateNSDeclarationIntentionFix.ExternalUriProcessor(){

            @Override
            public void process(@NotNull String currentUri, String url) {
                if (currentUri == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (currentUri.equals(uri) && url != null) {
                    schemaLocations.add(url);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentUri", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction$1", "process"));
            }
        });
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(ArrayUtilRt.toStringArray(schemaLocations), file.getProject(), new CreateNSDeclarationIntentionFix.StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NotNull String attrName) throws IncorrectOperationException {
                if (attrName == null) {
                    2.$$$reportNull$$$0(0);
                }
                AddXsiSchemaLocationForExtResourceAction.doIt(file, editor, uri, tag, attrName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction$2", "doSomethingWithGivenStringToProduceXmlAttributeNowPlease"));
            }
        }, XmlPsiBundle.message("xml.action.select.namespace.location.title", new Object[0]), (IntentionAction)this, editor);
    }

    private static void doIt(PsiFile file, Editor editor, String uri, XmlTag tag, String s) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance(file.getProject());
        if (tag.getAttributeValue(XMLNS_XSI_ATTR_NAME) == null) {
            tag.add(elementFactory.createXmlAttribute(XMLNS_XSI_ATTR_NAME, "http://www.w3.org/2001/XMLSchema-instance"));
        }
        XmlAttribute locationAttribute = tag.getAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME);
        String toInsert = uri + " " + s;
        int offset = s.length();
        if (locationAttribute == null) {
            tag.add(elementFactory.createXmlAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME, toInsert));
        } else {
            String newValue = locationAttribute.getValue() + "\n" + toInsert;
            locationAttribute.setValue(newValue);
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)tag);
        TextRange range = tag.getAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME).getValueElement().getTextRange();
        TextRange textRange = new TextRange(range.getEndOffset() - offset - 1, range.getEndOffset() - 1);
        editor.getCaretModel().moveToOffset(textRange.getStartOffset());
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            AddXsiSchemaLocationForExtResourceAction.$$$reportNull$$$0(3);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        XmlAttributeValue value2 = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
        if (value2 == null) {
            return false;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)value2, XmlAttribute.class);
        if (attribute != null && attribute.isNamespaceDeclaration()) {
            this.setText(XmlBundle.message(this.getQuickFixKeyId(), new Object[0]));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToMakeWritable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doInvoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

