/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.psi.XmlPsiBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @NonNls
    private static final String AMP_ENTITY = "&amp;";

    public void registerErrorQuickFix(@NotNull PsiErrorElement element, @NotNull HighlightInfo.Builder highlightInfo) {
        if (element == null) {
            XmlErrorQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (highlightInfo == null) {
            XmlErrorQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) == null) {
            return;
        }
        String text2 = element.getErrorDescription();
        if (text2.equals(XmlPsiBundle.message("xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]))) {
            final int textOffset = element.getTextOffset();
            highlightInfo.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    String string2 = XmlAnalysisBundle.message("xml.quickfix.escape.ampersand", new Object[0]);
                    if (string2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                @NotNull
                public String getFamilyName() {
                    String string2 = this.getText();
                    if (string2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string2;
                }

                public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return true;
                }

                public void invoke(@NotNull Project project2, Editor editor, PsiFile file) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile((PsiElement)file);
                    Document document2 = topLevelFile.getViewProvider().getDocument();
                    assert (document2 != null);
                    document2.replaceString(textOffset, textOffset + 1, (CharSequence)XmlErrorQuickFixProvider.AMP_ENTITY);
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 2, 3 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string2);
                        case 2, 3 -> new IllegalArgumentException(string2);
                    };
                }
            }, null, null, null, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "highlightInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlErrorQuickFixProvider";
        objectArray[2] = "registerErrorQuickFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

