/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadLocalRandom {
    private static final ThreadLocal<Tlr> tlr = ThreadLocal.withInitial(() -> new Tlr());
    private static final AtomicInteger probeGenerator = new AtomicInteger();
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final AtomicLong seeder = new AtomicLong();

    public static int getProbe() {
        return ThreadLocalRandom.tlr.get().threadLocalRandomProbe;
    }

    public static void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = ThreadLocalRandom.mix64(seeder.getAndAdd(-4942790177534073029L));
        Tlr t = tlr.get();
        t.threadLocalRandomProbe = probe;
        t.threadLocalRandomSeed = seed;
    }

    public static int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        ThreadLocalRandom.tlr.get().threadLocalRandomProbe = probe;
        return probe;
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    static class Tlr {
        long threadLocalRandomSeed;
        int threadLocalRandomProbe;

        Tlr() {
        }
    }
}

