/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.CollectionFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pluralizer {
    static final Pluralizer PLURALIZER;
    private final Map<String, String> irregularSingles = CollectionFactory.createCaseInsensitiveStringMap();
    private final Map<String, String> irregularPlurals = CollectionFactory.createCaseInsensitiveStringMap();
    private final Set<String> uncountables = CollectionFactory.createCaseInsensitiveStringSet();
    private final List<Map.Entry<Pattern, String>> pluralRules = new ArrayList<Map.Entry<Pattern, String>>();
    private final List<Map.Entry<Pattern, String>> singularRules = new ArrayList<Map.Entry<Pattern, String>>();

    public static String restoreCase(String word, String result2) {
        char lc;
        char uc;
        char wc;
        int i;
        if (word == null || result2 == null || Strings.areSameInstance(word, result2)) {
            return result2;
        }
        int len = Math.min(result2.length(), word.length());
        if (len == 0) {
            return result2;
        }
        char[] chars = result2.toCharArray();
        for (i = 0; i < len; ++i) {
            wc = word.charAt(i);
            if (chars[i] == wc && i != len - 1) continue;
            uc = Character.toUpperCase(chars[i]);
            lc = Character.toLowerCase(chars[i]);
            if (wc != lc && wc != uc) break;
            chars[i] = wc;
        }
        if (i > 0 && i < chars.length && (uc = Character.toUpperCase(wc = word.charAt(i - 1))) != (lc = Character.toLowerCase(wc))) {
            while (i < chars.length) {
                chars[i] = wc == uc ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
                ++i;
            }
        }
        return new String(chars);
    }

    private String sanitizeWord(String word, List<? extends Map.Entry<Pattern, String>> rules) {
        if (Strings.isEmpty(word) || this.uncountables.contains(word)) {
            return word;
        }
        int len = rules.size();
        while (--len > -1) {
            Map.Entry<Pattern, String> rule = rules.get(len);
            Matcher matcher = rule.getKey().matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(rule.getValue());
        }
        return null;
    }

    private String replaceWord(String word, Map<String, String> replaceMap, Map<String, String> keepMap, List<? extends Map.Entry<Pattern, String>> rules) {
        if (Strings.isEmpty(word)) {
            return word;
        }
        if (keepMap.containsKey(word)) {
            return word;
        }
        String replacement = replaceMap.get(word);
        if (replacement != null) {
            return replacement;
        }
        return this.sanitizeWord(word, rules);
    }

    @NotNull
    public String pluralize(@NotNull String word, int count2, boolean inclusive) {
        if (word == null) {
            Pluralizer.$$$reportNull$$$0(0);
        }
        String pluralized = count2 == 1 ? this.singular(word) : this.plural(word);
        String string2 = (inclusive ? count2 + " " : "") + Strings.notNullize(pluralized, word);
        if (string2 == null) {
            Pluralizer.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    public String plural(@Nullable String word) {
        return Pluralizer.restoreCase(word, this.replaceWord(word, this.irregularSingles, this.irregularPlurals, this.pluralRules));
    }

    @Nullable
    public String singular(@Nullable String word) {
        return Pluralizer.restoreCase(word, this.replaceWord(word, this.irregularPlurals, this.irregularSingles, this.singularRules));
    }

    private static Pattern sanitizeRule(String rule) {
        return Pattern.compile(rule.startsWith("/") ? rule.substring(1) : "^" + rule + "$", 2);
    }

    private void addPluralRule(String rule, String replacement) {
        this.pluralRules.add(new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pluralizer.sanitizeRule(rule), replacement));
    }

    private void addSingularRule(String rule, String replacement) {
        this.singularRules.add(new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pluralizer.sanitizeRule(rule), replacement));
    }

    private void addUncountableRule(String word) {
        if (!word.startsWith("/")) {
            this.uncountables.add(word);
        } else {
            this.addPluralRule(word, "$0");
            this.addSingularRule(word, "$0");
        }
    }

    private void addIrregularRule(String single2, String plural) {
        this.irregularSingles.put(single2, plural);
        this.irregularPlurals.put(plural, single2);
    }

    static {
        Pluralizer pluralizer = new Pluralizer();
        for (String[] stringArray : new String[][]{{"this", "these"}, {"that", "those"}, {"echo", "echoes"}, {"dingo", "dingoes"}, {"volcano", "volcanoes"}, {"tornado", "tornadoes"}, {"torpedo", "torpedoes"}, {"genus", "genera"}, {"viscus", "viscera"}, {"stigma", "stigmata"}, {"stoma", "stomata"}, {"dogma", "dogmata"}, {"lemma", "lemmata"}, {"anathema", "anathemata"}, {"ox", "oxen"}, {"axe", "axes"}, {"die", "dice"}, {"yes", "yeses"}, {"foot", "feet"}, {"eave", "eaves"}, {"goose", "geese"}, {"tooth", "teeth"}, {"quiz", "quizzes"}, {"human", "humans"}, {"proof", "proofs"}, {"carve", "carves"}, {"valve", "valves"}, {"looey", "looies"}, {"thief", "thieves"}, {"groove", "grooves"}, {"pickaxe", "pickaxes"}, {"whiskey", "whiskies"}}) {
            pluralizer.addIrregularRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[][]{{"/s?$", "s"}, {"/([^aeiou]ese)$", "$1"}, {"/(ax|test)is$", "$1es"}, {"/(alias|[^aou]us|t[lm]as|gas|ris)$", "$1es"}, {"/(e[mn]u)s?$", "$1s"}, {"/([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$", "$1"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1i"}, {"/(alumn|alg|vertebr)(?:a|ae)$", "$1ae"}, {"/(seraph|cherub)(?:im)?$", "$1im"}, {"/(her|at|gr)o$", "$1oes"}, {"/(agend|addend|millenni|medi|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$", "$1a"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$", "$1a"}, {"/sis$", "ses"}, {"/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$", "$1$2ves"}, {"/([^aeiouy]|qu)y$", "$1ies"}, {"/([^ch][ieo][ln])ey$", "$1ies"}, {"/(x|ch|ss|sh|zz)$", "$1es"}, {"/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$", "$1ices"}, {"(m|l)(?:ice|ouse)", "$1ice"}, {"/(pe)(?:rson|ople)$", "$1ople"}, {"/(child)(?:ren)?$", "$1ren"}, {"/eaux$", "$0"}, {"/m[ae]n$", "men"}}) {
            pluralizer.addPluralRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[][]{{"/(.)s$", "$1"}, {"/([^aeiou]s)es$", "$1"}, {"/(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$", "$1fe"}, {"/(ar|(?:wo|[ae])l|[eo][ao])ves$", "$1f"}, {"/ies$", "y"}, {"/\\b([pl]|zomb|(?:neck|cross)?t|coll|faer|food|gen|goon|group|lass|talk|goal|cut)ies$", "$1ie"}, {"/\\b(mon|smil)ies$", "$1ey"}, {"(m|l)ice", "$1ouse"}, {"/(seraph|cherub)im$", "$1"}, {"/.(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(analy|^ba|diagno|parenthe|progno|synop|the|empha|cri)(?:sis|ses)$", "$1sis"}, {"/(movie|twelve|abuse|e[mn]u)s$", "$1"}, {"/(test)(?:is|es)$", "$1is"}, {"/(x|ch|.ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(e[mn]u)s?$", "$1"}, {"/(cookie|movie|twelve)s$", "$1"}, {"/(cris|test|diagnos)(?:is|es)$", "$1is"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1us"}, {"/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$", "$1um"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$", "$1on"}, {"/(alumn|alg|vertebr)ae$", "$1a"}, {"/(cod|mur|sil|vert|ind)ices$", "$1ex"}, {"/(matr|append)ices$", "$1ix"}, {"/(pe)(rson|ople)$", "$1rson"}, {"/(child)ren$", "$1"}, {"/(eau)x?$", "$1"}, {"/men$", "man"}}) {
            pluralizer.addSingularRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[]{"adulthood", "advice", "agenda", "aid", "alcohol", "ammo", "anime", "athletics", "audio", "bison", "blood", "bream", "buffalo", "butter", "carp", "cash", "chassis", "chess", "clothing", "cod", "commerce", "cooperation", "corps", "debris", "diabetes", "digestion", "elk", "energy", "equipment", "excretion", "expertise", "flounder", "fun", "gallows", "garbage", "graffiti", "headquarters", "health", "herpes", "highjinks", "homework", "housework", "information", "jeans", "justice", "kudos", "labour", "literature", "machinery", "mackerel", "mail", "media", "mews", "moose", "music", "news", "pike", "plankton", "pliers", "police", "pollution", "premises", "rain", "research", "rice", "salmon", "scissors", "series", "sewage", "shambles", "shrimp", "species", "staff", "swine", "tennis", "traffic", "transportation", "trout", "tuna", "wealth", "welfare", "whiting", "wildebeest", "wildlife", "you", "/[^aeiou]ese$/i", "/deer$", "/fish$", "/measles$", "/o[iu]s$", "/pox$", "/sheep$"}) {
            pluralizer.addUncountableRule((String)stringArray);
        }
        PLURALIZER = pluralizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/Pluralizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/Pluralizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

