/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.interactive.GitRewordedCommitMessagesInfo;
import git4idea.rebase.interactive.RewordedCommitMessageMapping;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GitRewordedCommitMessages", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/interactive/GitRewordedCommitMessageProvider;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lgit4idea/rebase/interactive/GitRewordedCommitMessagesInfo;", "()V", "checkRebaseOnto", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRewordedCommitMessage", "", "originalMessage", "save", "", "mappings", "", "Lgit4idea/rebase/interactive/RewordedCommitMessageMapping;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRewordedCommitMessageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRewordedCommitMessageProvider.kt\ngit4idea/rebase/interactive/GitRewordedCommitMessageProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class GitRewordedCommitMessageProvider
extends SimplePersistentStateComponent<GitRewordedCommitMessagesInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GitRewordedCommitMessageProvider() {
        super((BaseState)new GitRewordedCommitMessagesInfo());
    }

    public final void save(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<RewordedCommitMessageMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Object object = GitRebaseUtils.getOntoHash(project, root);
        if (object == null || (object = object.asString()) == null) {
            return;
        }
        Object ontoHash = object;
        ((GitRewordedCommitMessagesInfo)this.getState()).setOnto((String)ontoHash);
        ((GitRewordedCommitMessagesInfo)this.getState()).setCurrentCommit(0);
        ((GitRewordedCommitMessagesInfo)this.getState()).getCommitMessagesMapping().clear();
        ((GitRewordedCommitMessagesInfo)this.getState()).getCommitMessagesMapping().addAll((Collection<RewordedCommitMessageMapping>)mappings);
    }

    @Nullable
    public final String getRewordedCommitMessage(@NotNull Project project, @NotNull VirtualFile root, @NotNull String originalMessage) {
        String string;
        String rewordedMessage;
        String string2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
        if (!this.checkRebaseOnto(project, root)) {
            return null;
        }
        List<RewordedCommitMessageMapping> commitMappings = ((GitRewordedCommitMessagesInfo)this.getState()).getCommitMessagesMapping();
        Integer n = ((GitRewordedCommitMessagesInfo)this.getState()).getCurrentCommit();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it < commitMappings.size() ? n : null;
        if (n2 == null) {
            return null;
        }
        int currentCommit = n2;
        RewordedCommitMessageMapping mapping = commitMappings.get(currentCommit);
        String string3 = mapping.getOriginalMessage();
        if (string3 == null) {
            return null;
        }
        String savedOriginalMessage = string3;
        String string4 = mapping.getRewordedMessage();
        if (string4 == null) {
            return null;
        }
        String it2 = string2 = (rewordedMessage = string4);
        boolean bl2 = false;
        String string5 = StringsKt.startsWith$default((String)originalMessage, (String)savedOriginalMessage, (boolean)false, (int)2, null) ? string2 : null;
        if (string5 != null) {
            it2 = string2 = string5;
            boolean bl3 = false;
            GitRewordedCommitMessagesInfo gitRewordedCommitMessagesInfo = (GitRewordedCommitMessagesInfo)this.getState();
            int n3 = gitRewordedCommitMessagesInfo.getCurrentCommit();
            gitRewordedCommitMessagesInfo.setCurrentCommit(n3 + 1);
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    private final boolean checkRebaseOnto(Project project, VirtualFile root) {
        Object object = GitRebaseUtils.getOntoHash(project, root);
        if (object == null || (object = object.asString()) == null) {
            return false;
        }
        Object currentRebaseOntoHash = object;
        String savedOntoHash = ((GitRewordedCommitMessagesInfo)this.getState()).getOnto();
        return Intrinsics.areEqual((Object)currentRebaseOntoHash, (Object)savedOntoHash);
    }

    @JvmStatic
    @NotNull
    public static final GitRewordedCommitMessageProvider getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/GitRewordedCommitMessageProvider$Companion;", "", "()V", "getInstance", "Lgit4idea/rebase/interactive/GitRewordedCommitMessageProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRewordedCommitMessageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRewordedCommitMessageProvider.kt\ngit4idea/rebase/interactive/GitRewordedCommitMessageProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,72:1\n29#2,3:73\n*S KotlinDebug\n*F\n+ 1 GitRewordedCommitMessageProvider.kt\ngit4idea/rebase/interactive/GitRewordedCommitMessageProvider$Companion\n*L\n20#1:73,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitRewordedCommitMessageProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitRewordedCommitMessageProvider> serviceClass$iv = GitRewordedCommitMessageProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (GitRewordedCommitMessageProvider)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

