/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestProducer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageDiffUtilKt;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/index/actions/GitStageCompareThreeVersionsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
public final class GitStageCompareThreeVersionsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project) || file2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus status = GitStageTrackerKt.status(gitStageTracker, file2);
        e.getPresentation().setVisible(status != null);
        GitFileStatus gitFileStatus = status;
        e.getPresentation().setEnabled((gitFileStatus != null ? GitFileStatusKt.has(gitFileStatus, ContentVersion.HEAD) : false) && GitFileStatusKt.has(status, ContentVersion.STAGED) && GitFileStatusKt.has(status, ContentVersion.LOCAL));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        Object object = e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.VIRTUAL_FILE)");
        VirtualFile file2 = (VirtualFile)object;
        VirtualFile virtualFile = GitStageTrackerKt.getRoot(project2, file2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, root, file2);
        if (gitFileStatus == null) {
            return;
        }
        GitFileStatus status = gitFileStatus;
        DiffRequestProducer diffRequestProducer = SimpleDiffRequestProducer.create((FilePath)GitIndexVirtualFileKt.filePath(file2), () -> GitStageCompareThreeVersionsAction.actionPerformed$lambda$0(project2, root, status));
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestProducer, (String)"create(file.filePath(), \u2026ect, root, status)\n    })");
        DiffRequestProducer producer = diffRequestProducer;
        DiffManager.getInstance().showDiff(e.getProject(), (DiffRequestChain)SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer), DiffDialogHints.DEFAULT);
    }

    private static final DiffRequest actionPerformed$lambda$0(Project $project, VirtualFile $root, GitFileStatus $status) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
        return GitStageDiffUtilKt.compareThreeVersions($project, $root, $status);
    }
}

