/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.SortingException;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B\u0014\b\u0016\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/extensions/LoadingOrder;", "", "()V", "text", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "after", "", "before", "first", "", "last", "name", "equals", "other", "hashCode", "", "toString", "Companion", "Orderable", "intellij.platform.extensions"})
@ApiStatus.Internal
public final class LoadingOrder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean first;
    private final boolean last;
    @NotNull
    private final Set<String> before;
    @NotNull
    private final Set<String> after;
    @NotNull
    public static final String FIRST_STR = "first";
    @NotNull
    public static final String LAST_STR = "last";
    @NotNull
    public static final String BEFORE_STR = "before ";
    @NotNull
    public static final String BEFORE_STR_OLD = "before:";
    @NotNull
    public static final String AFTER_STR = "after ";
    @NotNull
    public static final String AFTER_STR_OLD = "after:";
    public static final char ORDER_RULE_SEPARATOR = ',';
    @JvmField
    @NotNull
    public static final LoadingOrder ANY = new LoadingOrder();
    @JvmField
    @NotNull
    public static final LoadingOrder FIRST = new LoadingOrder("first");
    @JvmField
    @NotNull
    public static final LoadingOrder LAST = new LoadingOrder("last");

    private LoadingOrder() {
        this.name = "ANY";
        this.first = false;
        this.last = false;
        this.before = SetsKt.emptySet();
        this.after = SetsKt.emptySet();
    }

    public LoadingOrder(@NotNull String text) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.name = text;
        boolean last = false;
        boolean first = false;
        Set<String> before = null;
        Set after = null;
        char[] cArray = new char[]{','};
        for (String s : SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null), (Function1)1.INSTANCE), (Function1)2.INSTANCE)) {
            if (StringsKt.equals((String)s, (String)FIRST_STR, (boolean)true)) {
                first = true;
                continue;
            }
            if (StringsKt.equals((String)s, (String)LAST_STR, (boolean)true)) {
                last = true;
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)BEFORE_STR, (boolean)true)) {
                if (before == null) {
                    before = new LinkedHashSet(2);
                }
                String string = s.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                before.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)BEFORE_STR_OLD, (boolean)true)) {
                if (before == null) {
                    before = new LinkedHashSet(2);
                }
                String string = s.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                before.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)AFTER_STR, (boolean)true)) {
                if (after == null) {
                    after = new LinkedHashSet(2);
                }
                String string = s.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                after.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)AFTER_STR_OLD, (boolean)true)) {
                if (after == null) {
                    after = new LinkedHashSet(2);
                }
                String string = s.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                after.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + s + "; should be one of first, last, before <id> or after <id>"));
        }
        Set<String> set2 = before;
        if (set2 == null) {
            set2 = this.before = SetsKt.emptySet();
        }
        if ((set = after) == null) {
            set = SetsKt.emptySet();
        }
        this.after = set;
        this.first = first;
        this.last = last;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadingOrder)) {
            return false;
        }
        return this.first == ((LoadingOrder)other).first && this.last == ((LoadingOrder)other).last && Intrinsics.areEqual(this.after, ((LoadingOrder)other).after) && Intrinsics.areEqual(this.before, ((LoadingOrder)other).before);
    }

    public int hashCode() {
        int result = this.first ? 1 : 0;
        result = 31 * result + (this.last ? 1 : 0);
        result = 31 * result + ((Object)this.before).hashCode();
        result = 31 * result + ((Object)this.after).hashCode();
        return result;
    }

    @JvmStatic
    @NotNull
    public static final LoadingOrder before(@Nullable String id) {
        return Companion.before(id);
    }

    @JvmStatic
    @NotNull
    public static final LoadingOrder after(@Nullable String id) {
        return Companion.after(id);
    }

    @JvmStatic
    @NotNull
    public static final LoadingOrder readOrder(@Nullable String orderAttr) {
        return Companion.readOrder(orderAttr);
    }

    public static final /* synthetic */ Set access$getAfter$p(LoadingOrder $this) {
        return $this.after;
    }

    public static final /* synthetic */ boolean access$getLast$p(LoadingOrder $this) {
        return $this.last;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0011\u001a\u00020\b2\r\u0010\u0012\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005H\u0007J\u0017\u0010\u0013\u001a\u00020\b2\r\u0010\u0012\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005H\u0007J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J\u0016\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/extensions/LoadingOrder$Companion;", "", "()V", "AFTER_STR", "", "Lorg/jetbrains/annotations/NonNls;", "AFTER_STR_OLD", "ANY", "Lcom/intellij/openapi/extensions/LoadingOrder;", "BEFORE_STR", "BEFORE_STR_OLD", "FIRST", "FIRST_STR", "LAST", "LAST_STR", "ORDER_RULE_SEPARATOR", "", "after", "id", "before", "readOrder", "orderAttr", "sort", "", "orderable", "", "Lcom/intellij/openapi/extensions/LoadingOrder$Orderable;", "intellij.platform.extensions"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LoadingOrder before(@Nullable String id) {
            return new LoadingOrder(LoadingOrder.BEFORE_STR + id);
        }

        @JvmStatic
        @NotNull
        public final LoadingOrder after(@Nullable String id) {
            return new LoadingOrder(LoadingOrder.AFTER_STR + id);
        }

        public final void sort(@NotNull List<? extends Orderable> orderable) {
            Orderable[] orderableArray;
            Intrinsics.checkNotNullParameter(orderable, (String)"orderable");
            if (orderable.size() < 2) {
                return;
            }
            LinkedHashMap<String, Orderable> map = new LinkedHashMap<String, Orderable>();
            LinkedHashMap<Orderable, LoadingOrder> cachedMap = new LinkedHashMap<Orderable, LoadingOrder>();
            LinkedHashSet<Orderable> first = new LinkedHashSet<Orderable>(1);
            LinkedHashSet<Orderable> hasBefore = new LinkedHashSet<Orderable>(orderable.size());
            for (Orderable orderable2 : orderable) {
                LoadingOrder order;
                String id = orderable2.getOrderId();
                orderableArray = (Orderable[])id;
                if (!(orderableArray == null || orderableArray.length() == 0)) {
                    map.put(id, orderable2);
                }
                if ((order = orderable2.getOrder()) == ANY) continue;
                cachedMap.put(orderable2, order);
                if (order.first) {
                    first.add(orderable2);
                }
                if (order.before.isEmpty()) continue;
                hasBefore.add(orderable2);
            }
            if (cachedMap.isEmpty()) {
                return;
            }
            InboundSemiGraph<Orderable> graph2 = new InboundSemiGraph<Orderable>(orderable, cachedMap, map, hasBefore, first){
                final /* synthetic */ List<? extends Orderable> $orderable;
                final /* synthetic */ LinkedHashMap<Orderable, LoadingOrder> $cachedMap;
                final /* synthetic */ LinkedHashMap<String, Orderable> $map;
                final /* synthetic */ LinkedHashSet<Orderable> $hasBefore;
                final /* synthetic */ LinkedHashSet<Orderable> $first;
                {
                    this.$orderable = $orderable;
                    this.$cachedMap = $cachedMap;
                    this.$map = $map;
                    this.$hasBefore = $hasBefore;
                    this.$first = $first;
                }

                @NotNull
                public Collection<Orderable> getNodes() {
                    return CollectionsKt.reversed((Iterable)this.$orderable);
                }

                @NotNull
                public Iterator<Orderable> getIn(@NotNull Orderable n) {
                    LoadingOrder hisOrder;
                    Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                    LoadingOrder loadingOrder = this.$cachedMap.getOrDefault(n, LoadingOrder.ANY);
                    Intrinsics.checkNotNullExpressionValue((Object)loadingOrder, (String)"cachedMap.getOrDefault(n, ANY)");
                    LoadingOrder order = loadingOrder;
                    LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                    for (String id : LoadingOrder.access$getAfter$p(order)) {
                        Orderable orderable = this.$map.get(id);
                        if (orderable == null) continue;
                        predecessors.add(orderable);
                    }
                    String id = n.getOrderId();
                    CharSequence charSequence = id;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        for (Orderable orderable : this.$hasBefore) {
                            Intrinsics.checkNotNullExpressionValue((Object)this.$cachedMap.getOrDefault(orderable, LoadingOrder.ANY), (String)"cachedMap.getOrDefault(o, ANY)");
                            if (!LoadingOrder.access$getBefore$p(hisOrder).contains(id)) continue;
                            predecessors.add(orderable);
                        }
                    }
                    if (LoadingOrder.access$getLast$p(order)) {
                        for (Orderable orderable : this.$orderable) {
                            Intrinsics.checkNotNullExpressionValue((Object)this.$cachedMap.getOrDefault(orderable, LoadingOrder.ANY), (String)"cachedMap.getOrDefault(o, ANY)");
                            if (LoadingOrder.access$getLast$p(hisOrder)) continue;
                            predecessors.add(orderable);
                        }
                    }
                    if (!LoadingOrder.access$getFirst$p(order)) {
                        predecessors.addAll((Collection)this.$first);
                    }
                    Iterator<Orderable> iterator2 = predecessors.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"predecessors.iterator()");
                    return iterator2;
                }
            };
            DFSTBuilder dFSTBuilder = new DFSTBuilder((OutboundSemiGraph)GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)((InboundSemiGraph)graph2))));
            if (!dFSTBuilder.isAcyclic()) {
                Map.Entry entry = dFSTBuilder.getCircularDependency();
                Intrinsics.checkNotNull((Object)entry);
                Map.Entry p = entry;
                orderableArray = new Orderable[]{p.getKey(), p.getValue()};
                throw new SortingException("Could not satisfy sorting requirements", orderableArray);
            }
            Comparator comparator = dFSTBuilder.comparator();
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"builder.comparator()");
            CollectionsKt.sortWith(orderable, (Comparator)comparator);
        }

        @JvmStatic
        @NotNull
        public final LoadingOrder readOrder(@Nullable String orderAttr) {
            String string = orderAttr;
            return string == null ? ANY : (Intrinsics.areEqual((Object)string, (Object)LoadingOrder.FIRST_STR) ? FIRST : (Intrinsics.areEqual((Object)string, (Object)LoadingOrder.LAST_STR) ? LAST : new LoadingOrder(orderAttr)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/extensions/LoadingOrder$Orderable;", "", "order", "Lcom/intellij/openapi/extensions/LoadingOrder;", "getOrder", "()Lcom/intellij/openapi/extensions/LoadingOrder;", "orderId", "", "getOrderId", "()Ljava/lang/String;", "intellij.platform.extensions"})
    public static interface Orderable {
        @Nullable
        public String getOrderId();

        @NotNull
        public LoadingOrder getOrder();
    }
}

