/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder;
    private final StringBuilder myStderrBuilder;
    @Nullable
    private Integer myExitCode;
    private boolean myTimeout;
    private boolean myCancelled;

    public ProcessOutput() {
        this.myStdoutBuilder = new StringBuilder();
        this.myStderrBuilder = new StringBuilder();
    }

    public ProcessOutput(int exitCode) {
        this.myStdoutBuilder = new StringBuilder();
        this.myStderrBuilder = new StringBuilder();
        this.myExitCode = exitCode;
    }

    public ProcessOutput(@NotNull String stdout, @NotNull String stderr, int exitCode, boolean timeout, boolean cancelled) {
        if (stdout == null) {
            ProcessOutput.$$$reportNull$$$0(0);
        }
        if (stderr == null) {
            ProcessOutput.$$$reportNull$$$0(1);
        }
        this.myStdoutBuilder = new StringBuilder();
        this.myStderrBuilder = new StringBuilder();
        this.myStdoutBuilder.append(stdout);
        this.myStderrBuilder.append(stderr);
        this.myExitCode = exitCode;
        this.myTimeout = timeout;
        this.myCancelled = cancelled;
    }

    public void appendStdout(@Nullable String text) {
        this.myStdoutBuilder.append(text);
    }

    public void appendStderr(@Nullable String text) {
        this.myStderrBuilder.append(text);
    }

    @NotNull
    @NlsSafe
    public String getStdout() {
        String string = this.myStdoutBuilder.toString();
        if (string == null) {
            ProcessOutput.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getStderr() {
        String string = this.myStderrBuilder.toString();
        if (string == null) {
            ProcessOutput.$$$reportNull$$$0(3);
        }
        return string;
    }

    public @NotNull List<@NlsSafe String> getStdoutLines() {
        List<String> list = this.getStdoutLines(true);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(4);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getStdoutLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStdout(), excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(5);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getStderrLines() {
        List<String> list = this.getStderrLines(true);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(6);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getStderrLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStderr(), excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static List<String> splitLines(String s, boolean excludeEmptyLines) {
        String converted = StringUtil.convertLineSeparators((String)s);
        return StringUtil.split((String)converted, (String)"\n", (boolean)true, (boolean)excludeEmptyLines);
    }

    public boolean checkSuccess(@NotNull Logger logger) {
        int ec;
        if (logger == null) {
            ProcessOutput.$$$reportNull$$$0(8);
        }
        if ((ec = this.getExitCode()) == 0 && !this.isTimeout()) {
            return true;
        }
        logger.info((String)(this.isTimeout() ? "Timed out" : "Exit code " + ec));
        String output = this.getStderr();
        if (output.isEmpty()) {
            output = this.getStdout();
        }
        if (!output.isEmpty()) {
            logger.info(output);
        }
        return false;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        Integer code = this.myExitCode;
        return code == null ? -1 : code;
    }

    public boolean isExitCodeSet() {
        return this.myExitCode != null;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    public String toString() {
        return "{exitCode=" + this.myExitCode + ", timeout=" + this.myTimeout + ", cancelled=" + this.myCancelled + ", stdout=" + this.myStdoutBuilder + ", stderr=" + this.myStderrBuilder + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessOutput";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessOutput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdoutLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderrLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkSuccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

