/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class DoublePunctuationRule
extends Rule {
    public DoublePunctuationRule(ResourceBundle messages) {
        this(messages, null);
    }

    public DoublePunctuationRule(ResourceBundle messages, URL url2) {
        super(messages);
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Typographical);
        if (url2 != null) {
            this.setUrl(url2);
        }
    }

    @Override
    public String getId() {
        return "DOUBLE_PUNCTUATION";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_double_punct");
    }

    public String getCommaCharacter() {
        return ",";
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        int startPos = 0;
        int dotCount = 0;
        int commaCount = 0;
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            int fromPos;
            String token = tokens[i].getToken();
            String nextToken = null;
            String prevPrevToken = null;
            if (i < tokens.length - 1) {
                nextToken = tokens[i + 1].getToken();
            }
            if (i > 1) {
                prevPrevToken = tokens[i - 2].getToken();
            }
            if (".".equals(token)) {
                ++dotCount;
                commaCount = 0;
                startPos = tokens[i].getStartPos();
            } else if (this.getCommaCharacter().equals(token)) {
                ++commaCount;
                dotCount = 0;
                startPos = tokens[i].getStartPos();
            }
            if (!(dotCount != 2 || ".".equals(nextToken) || "\u2026".equals(nextToken) || "/".equals(token) || "/".equals(nextToken) || "\\".equals(token) || "\\".equals(nextToken) || "?".equals(prevPrevToken) || "!".equals(prevPrevToken) || "\u2026".equals(prevPrevToken) || ".".equals(prevPrevToken))) {
                fromPos = Math.max(0, startPos - 1);
                ruleMatch = new RuleMatch(this, sentence, fromPos, startPos + 1, this.getDotMessage(), this.messages.getString("double_dots_short"));
                ruleMatch.addSuggestedReplacement(".");
                ruleMatch.addSuggestedReplacement("\u2026");
                ruleMatches.add(ruleMatch);
                dotCount = 0;
            } else if (commaCount == 2 && !this.getCommaCharacter().equals(nextToken)) {
                fromPos = Math.max(0, startPos - 1);
                ruleMatch = new RuleMatch(this, sentence, fromPos, startPos + 1, this.getCommaMessage(), this.messages.getString("double_commas_short"));
                ruleMatch.setSuggestedReplacement(this.getCommaCharacter());
                ruleMatches.add(ruleMatch);
                commaCount = 0;
            }
            if (".".equals(token) || this.getCommaCharacter().equals(token)) continue;
            dotCount = 0;
            commaCount = 0;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected String getDotMessage() {
        return this.messages.getString("two_dots");
    }

    protected String getCommaMessage() {
        return this.messages.getString("two_commas");
    }
}

