/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.commit;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.SpellCheckerSeveritiesProvider;
import java.util.EnumSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class CommitAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            CommitAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CommitAnnotator.$$$reportNull$$$0(1);
        }
        if (!CommitMessage.isCommitMessage((PsiElement)element) || !GrazieConfig.Companion.get().getCheckingContext().isCheckInCommitMessagesEnabled()) {
            return;
        }
        for (TextContent text2 : TextExtractor.findTextsAt(element, EnumSet.of(TextContent.TextDomain.PLAIN_TEXT))) {
            CommitAnnotator.checkText(holder, text2);
        }
    }

    private static void checkText(AnnotationHolder holder, TextContent text2) {
        List<TextChecker> checkers = TextChecker.allCheckers();
        CheckerRunner runner = new CheckerRunner(text2);
        runner.run(checkers, (Function1<? super TextProblem, Unit>)((Function1)problem -> {
            if (problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE) && Text.isSingleSentence(Text.findParagraphRange(text2, problem.getHighlightRanges().get(0)).subSequence((CharSequence)text2))) {
                return null;
            }
            List<ProblemDescriptor> descriptors = runner.toProblemDescriptors((TextProblem)problem, true);
            if (descriptors.isEmpty()) {
                return null;
            }
            String message = problem.getDescriptionTemplate(true);
            String tooltip = problem.getTooltipTemplate();
            LocalQuickFix[] fixes = runner.toFixes((TextProblem)problem, descriptors.get(0));
            for (TextRange range : problem.getHighlightRanges()) {
                AnnotationBuilder annotation = holder.newAnnotation(HighlightSeverity.WARNING, message).tooltip(tooltip).textAttributes(SpellCheckerSeveritiesProvider.TYPO_KEY).range(text2.textRangeToFile(range));
                for (LocalQuickFix fix : fixes) {
                    annotation = annotation.withFix((IntentionAction)fix);
                }
                annotation.create();
            }
            return null;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/grazie/ide/language/commit/CommitAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

