/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowRepositoryContentController;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPROpenPullRequestAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.github"})
public final class GHPROpenPullRequestAction
extends DumbAwareAction {
    public GHPROpenPullRequestAction() {
        super(GithubBundle.messagePointer("pull.request.open.action", new Object[0]), GithubBundle.messagePointer("pull.request.open.action.description", new Object[0]), null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GHPRToolWindowRepositoryContentController controller = (GHPRToolWindowRepositoryContentController)e.getData(GHPRActionKeys.getPULL_REQUESTS_CONTENT_CONTROLLER());
        GHPullRequestShort selection = (GHPullRequestShort)e.getData(GHPRActionKeys.getSELECTED_PULL_REQUEST());
        GHPRDataProvider dataProvider = (GHPRDataProvider)e.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        e.getPresentation().setEnabledAndVisible(controller != null && (selection != null || dataProvider != null));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GHPRIdentifier gHPRIdentifier;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(GHPRActionKeys.getPULL_REQUESTS_CONTENT_CONTROLLER());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(GHPRAc\u2026UESTS_CONTENT_CONTROLLER)");
        GHPRToolWindowRepositoryContentController controller = (GHPRToolWindowRepositoryContentController)object;
        GHPullRequestShort selection = (GHPullRequestShort)e.getData(GHPRActionKeys.getSELECTED_PULL_REQUEST());
        GHPRDataProvider dataProvider = (GHPRDataProvider)e.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        GHPullRequestShort gHPullRequestShort = selection;
        if (gHPullRequestShort != null) {
            gHPRIdentifier = gHPullRequestShort;
        } else {
            GHPRDataProvider gHPRDataProvider = dataProvider;
            Intrinsics.checkNotNull((Object)gHPRDataProvider);
            gHPRIdentifier = gHPRDataProvider.getId();
        }
        GHPRIdentifier pullRequest = gHPRIdentifier;
        GHPRToolWindowRepositoryContentController.viewPullRequest$default(controller, pullRequest, false, 2, null);
        controller.openPullRequestTimeline(pullRequest, false);
    }
}

