/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.MainCoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.ui.GHLoginDialogKt;
import org.jetbrains.plugins.github.authentication.ui.GHLoginModel;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginPanel;
import org.jetbrains.plugins.github.i18n.GithubBundle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002 !B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "model", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "(Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;)V", "cs", "Lkotlinx/coroutines/CoroutineScope;", "loginPanel", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel;", "getLoginPanel", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel;", "doOKAction", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "setError", "exception", "", "setLogin", "login", "", "editable", "", "setServer", "path", "OAuth", "Token", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog$OAuth;", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog$Token;", "intellij.vcs.github"})
public abstract class GHLoginDialog
extends DialogWrapper {
    @NotNull
    private final GHLoginModel model;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GithubLoginPanel loginPanel;

    private GHLoginDialog(GHLoginModel model2, Project project, Component parent) {
        super(project, parent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.model = model2;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"disposable");
        this.cs = CoroutineUtilKt.DisposingMainScope((Disposable)disposable);
        this.loginPanel = new GithubLoginPanel(GithubApiRequestExecutor.Factory.Companion.getInstance(), (Function2<? super String, ? super GithubServerPath, Boolean>)((Function2)new Function2<String, GithubServerPath, Boolean>(this){
            final /* synthetic */ GHLoginDialog this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull String login2, @NotNull GithubServerPath server) {
                Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return GHLoginDialog.access$getModel$p(this.this$0).isAccountUnique(server, login2);
            }
        }));
    }

    @NotNull
    protected final GithubLoginPanel getLoginPanel() {
        return this.loginPanel;
    }

    public final void setLogin(@Nullable String login2, boolean editable) {
        this.loginPanel.setLogin(login2, editable);
    }

    public final void setServer(@NotNull String path, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.loginPanel.setServer(path, editable);
    }

    public final void setError(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.loginPanel.setError(exception);
        this.startTrackingValidation();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.loginPanel.getPreferredFocusableComponent();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        return this.loginPanel.doValidateAll();
    }

    protected void doOKAction() {
        MainCoroutineDispatcher mainCoroutineDispatcher = Dispatchers.getMain().getImmediate();
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.getRootPane());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(rootPane)");
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)mainCoroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GHLoginDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getLoginPanel().acquireLoginAndToken((Continuation<? super Pair<String, String>>)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl11
lbl10:
                        // 1 sources

                        return var5_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        var2_3 = (Pair)v0;
                        login = (String)var2_3.component1();
                        token = (String)var2_3.component2();
                        this.label = 2;
                        v1 = GHLoginDialog.access$getModel$p(this.this$0).saveLogin(this.this$0.getLoginPanel().getServer(), login, token, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl24
lbl23:
                        // 1 sources

                        return var5_2;
lbl24:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            this.this$0.close(0, true);
                        }
                        catch (Exception e) {
                            if (e instanceof CancellationException) {
                                this.this$0.close(1, false);
                                throw e;
                            }
                            this.this$0.setError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public /* synthetic */ GHLoginDialog(GHLoginModel model2, Project project, Component parent, DefaultConstructorMarker $constructor_marker) {
        this(model2, project, parent);
    }

    public static final /* synthetic */ GHLoginModel access$getModel$p(GHLoginDialog $this) {
        return $this.model;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog$OAuth;", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "model", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "(Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;)V", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    public static final class OAuth
    extends GHLoginDialog {
        public OAuth(@NotNull GHLoginModel model2, @Nullable Project project, @Nullable Component parent) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            super(model2, project, parent, null);
            this.setTitle(GithubBundle.message("login.to.github", new Object[0]));
            this.getLoginPanel().setOAuthUi();
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"cancelAction");
            return actionArray;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JComponent jComponent;
            JBPanel jBPanel = JBUI.Panels.simplePanel((Component)((Component)((Object)this.getLoginPanel()))).withPreferredWidth(200);
            Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"simplePanel(loginPanel)\n\u2026 .withPreferredWidth(200)");
            JComponent it = jComponent = GHLoginDialogKt.setPaddingCompensated((JComponent)jBPanel);
            boolean bl = false;
            UiNotifyConnector.doWhenFirstShown((JComponent)it, () -> OAuth.createCenterPanel$lambda$1$lambda$0(this));
            return jComponent;
        }

        private static final void createCenterPanel$lambda$1$lambda$0(OAuth this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.doOKAction();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0017\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog$Token;", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "model", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "(Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "setLoginButtonText", "", "text", "", "setLoginButtonText$intellij_vcs_github", "intellij.vcs.github"})
    public static final class Token
    extends GHLoginDialog {
        public Token(@NotNull GHLoginModel model2, @Nullable Project project, @Nullable Component parent) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            super(model2, project, parent, null);
            this.setTitle(GithubBundle.message("login.to.github", new Object[0]));
            String string = GitBundle.message((String)"login.dialog.button.login", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"login.dialog.button.login\")");
            this.setLoginButtonText$intellij_vcs_github(string);
            this.getLoginPanel().setTokenUi();
            this.init();
        }

        public final void setLoginButtonText$intellij_vcs_github(@NlsContexts.Button @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.setOKButtonText(text);
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return GHLoginDialogKt.setPaddingCompensated((JComponent)((Object)this.getLoginPanel()));
        }
    }
}

