/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleId
implements Comparable<ModuleId> {
    static final String ENCODE_SEPARATOR = ":#@#:";
    private static final Map<ModuleId, WeakReference<ModuleId>> CACHE = new WeakHashMap<ModuleId, WeakReference<ModuleId>>();
    private String organisation;
    private String name;
    private int hash;
    private Map<String, String> attributes = new HashMap<String, String>();
    public static final Pattern MID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)");

    public static ModuleId newInstance(String org, String name2) {
        return ModuleId.intern(new ModuleId(org, name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleId intern(ModuleId moduleId) {
        ModuleId r = null;
        Map<ModuleId, WeakReference<ModuleId>> map2 = CACHE;
        synchronized (map2) {
            WeakReference<ModuleId> ref2 = CACHE.get(moduleId);
            if (ref2 != null) {
                r = (ModuleId)ref2.get();
            }
            if (r == null) {
                r = moduleId;
                CACHE.put(r, new WeakReference<ModuleId>(r));
            }
        }
        return r;
    }

    public ModuleId(String organisation, String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("null name not allowed");
        }
        this.organisation = organisation;
        this.name = name2;
        this.attributes.put("organisation", organisation);
        this.attributes.put("module", name2);
    }

    public String getName() {
        return this.name;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleId)) {
            return false;
        }
        ModuleId other = (ModuleId)obj;
        return other.organisation == null ? this.organisation == null && other.name.equals(this.name) : other.organisation.equals(this.organisation) && other.name.equals(this.name);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.organisation == null ? 0 : this.organisation.hashCode());
            this.hash = this.hash * 13 + this.name.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.organisation + "#" + this.name;
    }

    @Override
    public int compareTo(ModuleId that) {
        int result2 = this.organisation.compareTo(that.organisation);
        if (result2 == 0) {
            result2 = this.name.compareTo(that.name);
        }
        return result2;
    }

    public String encodeToString() {
        return this.getOrganisation() + ENCODE_SEPARATOR + this.getName();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public static ModuleId decode(String encoded) {
        String[] parts = encoded.split(ENCODE_SEPARATOR);
        if (parts.length != 2) {
            throw new IllegalArgumentException("badly encoded module id: '" + encoded + "'");
        }
        return new ModuleId(parts[0], parts[1]);
    }

    public static ModuleId parse(String mid) {
        Matcher m2 = MID_PATTERN.matcher(mid);
        if (!m2.matches()) {
            throw new IllegalArgumentException("module text representation do not match expected pattern. given mid='" + mid + "' expected form=" + MID_PATTERN.pattern());
        }
        return ModuleId.newInstance(m2.group(1), m2.group(2));
    }
}

