/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.FileUtil;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager,
IvySettingsAware {
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PATTERN = "resolved-[organisation]-[module]-[revision].xml";
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PROPERTIES_PATTERN = "resolved-[organisation]-[module]-[revision].properties";
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";
    private IvySettings settings;

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File basedir) {
        this.setBasedir(basedir);
    }

    @Override
    public void setSettings(IvySettings settings2) {
        this.settings = settings2;
    }

    @Override
    public File getResolutionCacheRoot() {
        if (this.basedir == null) {
            if (this.settings == null) {
                throw new IllegalStateException("The 'basedir' or 'IvySettings' has not been set on the ResolutionCacheManager");
            }
            this.basedir = this.settings.getDefaultResolutionCacheBasedir();
        }
        return this.basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public void setResolvedIvyPattern(String cacheResolvedIvyPattern) {
        this.resolvedIvyPattern = cacheResolvedIvyPattern;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public void setResolvedIvyPropertiesPattern(String cacheResolvedIvyPropertiesPattern) {
        this.resolvedIvyPropertiesPattern = cacheResolvedIvyPropertiesPattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public File getResolvedIvyFileInCache(ModuleRevisionId mrid) {
        String file2 = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file2);
    }

    @Override
    public File getResolvedIvyPropertiesInCache(ModuleRevisionId mrid) {
        String file2 = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file2);
    }

    @Override
    public File getConfigurationResolveReportInCache(String resolveId, String conf) {
        return new File(this.getResolutionCacheRoot(), resolveId + "-" + conf + ".xml");
    }

    @Override
    public File[] getConfigurationResolveReportsInCache(String resolveId) {
        final String prefix = resolveId + "-";
        String suffix = ".xml";
        return this.getResolutionCacheRoot().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name2) {
                return name2.startsWith(prefix) && name2.endsWith(".xml");
            }
        });
    }

    @Override
    public ModuleDescriptor getResolvedModuleDescriptor(ModuleRevisionId mrid) throws ParseException, IOException {
        File ivyFile = this.getResolvedIvyFileInCache(mrid);
        if (!ivyFile.exists()) {
            throw new IllegalStateException("Ivy file not found in cache for " + mrid + "!");
        }
        Properties paths = new Properties();
        File parentsFile = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(mrid, mrid.getRevision() + "-parents"));
        if (parentsFile.exists()) {
            FileInputStream in = new FileInputStream(parentsFile);
            paths.load(in);
            in.close();
        }
        CacheParserSettings pSettings = new CacheParserSettings(this.settings, paths);
        URL ivyFileURL = ivyFile.toURI().toURL();
        return this.getModuleDescriptorParser(ivyFile).parseDescriptor(pSettings, ivyFileURL, false);
    }

    protected ModuleDescriptorParser getModuleDescriptorParser(File moduleDescriptorFile) {
        return XmlModuleDescriptorParser.getInstance();
    }

    @Override
    public void saveResolvedModuleDescriptor(ModuleDescriptor md) throws ParseException, IOException {
        ModuleRevisionId mrevId = md.getResolvedModuleRevisionId();
        File ivyFileInCache = this.getResolvedIvyFileInCache(mrevId);
        md.toIvyFile(ivyFileInCache);
        Properties paths = new Properties();
        this.saveLocalParents(mrevId, md, ivyFileInCache, paths);
        if (!paths.isEmpty()) {
            File parentsFile = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(mrevId, mrevId.getRevision() + "-parents"));
            FileOutputStream out = new FileOutputStream(parentsFile);
            paths.store(out, null);
            out.close();
        }
    }

    private void saveLocalParents(ModuleRevisionId baseMrevId, ModuleDescriptor md, File mdFile, Properties paths) throws ParseException, IOException {
        for (ExtendsDescriptor parent : md.getInheritedDescriptors()) {
            if (!parent.isLocal()) continue;
            ModuleDescriptor parentMd = parent.getParentMd();
            ModuleRevisionId pRevId = ModuleRevisionId.newInstance(baseMrevId, baseMrevId.getRevision() + "-parent." + paths.size());
            File parentFile = this.getResolvedIvyFileInCache(pRevId);
            parentMd.toIvyFile(parentFile);
            paths.setProperty(mdFile.getName() + "|" + parent.getLocation(), parentFile.getAbsolutePath());
            this.saveLocalParents(baseMrevId, parentMd, parentFile, paths);
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void clean() {
        FileUtil.forceDelete(this.getResolutionCacheRoot());
    }

    private static final class MapURLResolver
    extends RelativeUrlResolver {
        private Map<Object, Object> paths;
        private RelativeUrlResolver delegate;

        private MapURLResolver(Map<Object, Object> paths, RelativeUrlResolver delegate2) {
            this.paths = paths;
            this.delegate = delegate2;
        }

        @Override
        public URL getURL(URL context2, String url2) throws MalformedURLException {
            String file2;
            String path2 = context2.getPath();
            if (path2.contains("/") && this.paths.containsKey((file2 = path2.substring(path2.lastIndexOf(47) + 1)) + "|" + url2)) {
                File result2 = new File(this.paths.get(file2 + "|" + url2).toString());
                return result2.toURI().toURL();
            }
            return this.delegate.getURL(context2, url2);
        }
    }

    private static class CacheParserSettings
    implements ParserSettings {
        private ParserSettings delegate;
        private Map<Object, Object> parentPaths;

        public CacheParserSettings(ParserSettings delegate2, Map<Object, Object> parentPaths) {
            this.delegate = delegate2;
            this.parentPaths = parentPaths;
        }

        @Override
        public String substitute(String value2) {
            return this.delegate.substitute(value2);
        }

        @Override
        public Map<String, String> substitute(Map<String, String> strings) {
            return this.delegate.substitute(strings);
        }

        @Override
        public ResolutionCacheManager getResolutionCacheManager() {
            return this.delegate.getResolutionCacheManager();
        }

        @Override
        public ConflictManager getConflictManager(String name2) {
            return this.delegate.getConflictManager(name2);
        }

        @Override
        public PatternMatcher getMatcher(String matcherName) {
            return this.delegate.getMatcher(matcherName);
        }

        @Override
        public Namespace getNamespace(String namespace) {
            return this.delegate.getNamespace(namespace);
        }

        @Override
        public StatusManager getStatusManager() {
            return this.delegate.getStatusManager();
        }

        @Override
        public RelativeUrlResolver getRelativeUrlResolver() {
            return new MapURLResolver(this.parentPaths, this.delegate.getRelativeUrlResolver());
        }

        @Override
        public DependencyResolver getResolver(ModuleRevisionId mRevId) {
            return this.delegate.getResolver(mRevId);
        }

        @Override
        public File resolveFile(String filename) {
            return this.delegate.resolveFile(filename);
        }

        @Override
        public String getDefaultBranch(ModuleId moduleId) {
            return this.delegate.getDefaultBranch(moduleId);
        }

        @Override
        public Namespace getContextNamespace() {
            return this.delegate.getContextNamespace();
        }

        @Override
        public String getVariable(String value2) {
            return this.delegate.getVariable(value2);
        }

        @Override
        public TimeoutConstraint getTimeoutConstraint(String name2) {
            return this.delegate.getTimeoutConstraint(name2);
        }
    }
}

