/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class IvyBuildNumber
extends IvyTask {
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private String revSep = ".";
    private String prefix = "ivy.";
    private String defaultValue = "0";
    private String defaultBuildNumber = "0";
    private String resolver = null;

    public String getModule() {
        return this.module;
    }

    public void setModule(String module2) {
        this.module = module2;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch2) {
        this.branch = branch2;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String default1) {
        this.defaultValue = default1;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver2) {
        this.resolver = resolver2;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void doExecute() throws BuildException {
        ModuleRevisionId[] revisions;
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy buildnumber task");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy buildnumber task");
        }
        if (this.prefix == null) {
            throw new BuildException("null prefix not allowed");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings settings2 = ivy.getSettings();
        if (this.branch == null) {
            this.branch = settings2.getDefaultBranch(new ModuleId(this.organisation, this.module));
        }
        if (StringUtils.isNullOrEmpty(this.revision)) {
            this.revision = "latest.integration";
        } else if (!this.revision.endsWith("+")) {
            this.revision = this.revision + "+";
        }
        if (!this.prefix.endsWith(".") && !this.prefix.isEmpty()) {
            this.prefix = this.prefix + ".";
        }
        SearchEngine searcher = new SearchEngine(settings2);
        PatternMatcher patternMatcher = new PatternMatcher(){
            private PatternMatcher exact = new ExactPatternMatcher();
            private PatternMatcher regexp = new ExactOrRegexpPatternMatcher();

            @Override
            public Matcher getMatcher(String expression2) {
                if (expression2.equals(IvyBuildNumber.this.organisation) || expression2.equals(IvyBuildNumber.this.module) || expression2.equals(IvyBuildNumber.this.branch)) {
                    return this.exact.getMatcher(expression2);
                }
                return this.regexp.getMatcher(expression2);
            }

            @Override
            public String getName() {
                return "buildnumber-matcher";
            }
        };
        String revisionPattern = ".*";
        if (this.revision.endsWith("+")) {
            revisionPattern = Pattern.quote(this.revision.substring(0, this.revision.length() - 1)) + ".*";
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, revisionPattern);
        if (this.resolver == null) {
            revisions = searcher.listModules(mrid, patternMatcher);
        } else {
            DependencyResolver depResolver = settings2.getResolver(this.resolver);
            if (depResolver == null) {
                throw new BuildException("Unknown resolver: " + this.resolver);
            }
            revisions = searcher.listModules(depResolver, mrid, patternMatcher);
        }
        ArrayList<ResolvedModuleRevisionArtifactInfo> infos = new ArrayList<ResolvedModuleRevisionArtifactInfo>(revisions.length);
        for (ModuleRevisionId rev : revisions) {
            infos.add(new ResolvedModuleRevisionArtifactInfo(rev));
        }
        VersionMatcher matcher2 = settings2.getVersionMatcher();
        LatestStrategy latestStrategy = settings2.getLatestStrategy("latest-revision");
        List<ArtifactInfo> sorted = latestStrategy.sort(infos.toArray(new ArtifactInfo[revisions.length]));
        ModuleRevisionId askedMrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision);
        String foundRevision = null;
        ListIterator<ArtifactInfo> iter = sorted.listIterator(sorted.size());
        while (iter.hasPrevious()) {
            ResolvedModuleRevisionArtifactInfo info2 = (ResolvedModuleRevisionArtifactInfo)iter.previous();
            if (!matcher2.accept(askedMrid, info2.rmr)) continue;
            if (matcher2.needModuleDescriptor(askedMrid, info2.rmr)) {
                ResolvedModuleRevision rmr = ivy.findModule(info2.rmr);
                if (matcher2.accept(askedMrid, rmr.getDescriptor())) {
                    foundRevision = info2.rmr.getRevision();
                }
            } else {
                foundRevision = info2.rmr.getRevision();
            }
            if (foundRevision == null) continue;
            break;
        }
        NewRevision newRevision = this.computeNewRevision(foundRevision);
        this.setProperty("revision", newRevision.getRevision());
        this.setProperty("new.revision", newRevision.getNewRevision());
        this.setProperty("build.number", newRevision.getBuildNumber());
        this.setProperty("new.build.number", newRevision.getNewBuildNumber());
    }

    private void setProperty(String propertyName2, String value2) {
        if (value2 != null) {
            this.getProject().setProperty(this.prefix + propertyName2, value2);
        }
    }

    private NewRevision computeNewRevision(String revision) {
        Range r;
        String revPrefix;
        String string2 = revPrefix = "latest.integration".equals(this.revision) ? "" : this.revision.substring(0, this.revision.length() - 1);
        if (revision != null && !revision.startsWith(revPrefix)) {
            throw new BuildException("invalid exception found in repository: '" + revision + "' for '" + revPrefix + "'");
        }
        if (revision == null) {
            if (revPrefix.length() > 0) {
                return new NewRevision(revision, revPrefix + (revPrefix.endsWith(this.revSep) ? this.defaultBuildNumber : this.revSep + this.defaultBuildNumber), null, this.defaultBuildNumber);
            }
            Range r2 = this.findLastNumber(this.defaultValue);
            if (r2 == null) {
                return new NewRevision(revision, this.defaultValue, null, null);
            }
            long n = Long.parseLong(this.defaultValue.substring(r2.getStartIndex(), r2.getEndIndex()));
            return new NewRevision(revision, this.defaultValue, null, String.valueOf(n));
        }
        if (revPrefix.length() == 0) {
            r = this.findLastNumber(revision);
            if (r == null) {
                return new NewRevision(revision, revision + (revision.endsWith(this.revSep) ? "1" : this.revSep + "1"), null, "1");
            }
        } else {
            r = this.findFirstNumber(revision, revPrefix.length());
            if (r == null) {
                return new NewRevision(revision, revPrefix + (revPrefix.endsWith(this.revSep) ? "1" : this.revSep + "1"), null, "1");
            }
        }
        long n = Long.parseLong(revision.substring(r.getStartIndex(), r.getEndIndex())) + 1L;
        return new NewRevision(revision, revision.substring(0, r.getStartIndex()) + n, String.valueOf(n - 1L), String.valueOf(n));
    }

    private Range findFirstNumber(String str, int startIndex) {
        int endNumberIndex;
        int startNumberIndex;
        for (startNumberIndex = startIndex; startNumberIndex < str.length() && !Character.isDigit(str.charAt(startNumberIndex)); ++startNumberIndex) {
        }
        if (startNumberIndex == str.length()) {
            return null;
        }
        for (endNumberIndex = startNumberIndex + 1; endNumberIndex < str.length() && Character.isDigit(str.charAt(endNumberIndex)); ++endNumberIndex) {
        }
        return new Range(startNumberIndex, endNumberIndex);
    }

    private Range findLastNumber(String str) {
        int startNumberIndex;
        int endNumberIndex;
        for (endNumberIndex = str.length() - 1; endNumberIndex >= 0 && !Character.isDigit(str.charAt(endNumberIndex)); --endNumberIndex) {
        }
        int n = startNumberIndex = endNumberIndex == -1 ? -1 : endNumberIndex - 1;
        while (startNumberIndex >= 0 && Character.isDigit(str.charAt(startNumberIndex))) {
            --startNumberIndex;
        }
        if (++startNumberIndex == ++endNumberIndex) {
            return null;
        }
        return new Range(startNumberIndex, endNumberIndex);
    }

    public String getRevSep() {
        return this.revSep;
    }

    public void setRevSep(String revSep) {
        this.revSep = revSep;
    }

    public String getDefaultBuildNumber() {
        return this.defaultBuildNumber;
    }

    public void setDefaultBuildNumber(String defaultBuildNumber) {
        this.defaultBuildNumber = defaultBuildNumber;
    }

    private static class NewRevision {
        private String revision;
        private String newRevision;
        private String buildNumber;
        private String newBuildNumber;

        public NewRevision(String revision, String newRevision, String buildNumber, String newBuildNumber) {
            this.revision = revision;
            this.newRevision = newRevision;
            this.buildNumber = buildNumber;
            this.newBuildNumber = newBuildNumber;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getNewRevision() {
            return this.newRevision;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getNewBuildNumber() {
            return this.newBuildNumber;
        }
    }

    private static class Range {
        private int startIndex;
        private int endIndex;

        public Range(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ModuleRevisionId rmr;

        public ResolvedModuleRevisionArtifactInfo(ModuleRevisionId rmr) {
            this.rmr = rmr;
        }

        @Override
        public String getRevision() {
            return this.rmr.getRevision();
        }

        @Override
        public long getLastModified() {
            return -1L;
        }
    }
}

