/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.details;

import circlet.code.api.CodeReviewServiceKt;
import circlet.code.api.MergeRequestBranch;
import circlet.code.api.MergeRequestBranchPair;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.details.MergeRequestDetailsVm;
import com.intellij.space.vcs.review.details.SpaceReviewCheckoutBranchActionKt;
import git4idea.GitLocalBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.fetch.GitFetchSupport;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002JF\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/space/vcs/review/details/SpaceReviewCheckoutBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkoutLocalBranch", "project", "Lcom/intellij/openapi/project/Project;", "detailsVm", "Lcom/intellij/space/vcs/review/details/MergeRequestDetailsVm;", "localBranch", "Lgit4idea/GitLocalBranch;", "gitRepositories", "", "Lgit4idea/repo/GitRepository;", "checkoutRemoteBranch", "gitRepository", "repoInfo", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "sourceBranchInfo", "Lcirclet/code/api/MergeRequestBranch;", "options", "Lgit4idea/branch/GitNewBranchOptions;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.space.vcs"})
public final class SpaceReviewCheckoutBranchAction
extends DumbAwareAction {
    public SpaceReviewCheckoutBranchAction() {
        super(SpaceBundle.messagePointer("review.actions.checkout.branch", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MergeRequestDetailsVm detailsVm = SpaceReviewCheckoutBranchActionKt.access$getMergeRequestVm(e);
        if (detailsVm == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SpaceRepoInfo repoInfo2 = detailsVm.getRepoInfo().getValue();
        if (repoInfo2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitLocalBranch localBranch = detailsVm.getMergeRequestBranchInfoProp().getValue().getLocalBranch();
        if (localBranch != null) {
            if (Intrinsics.areEqual((Object)repoInfo2.getRepository().getCurrentBranchName(), (Object)localBranch.getName())) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Object[] objectArray = new Object[]{localBranch};
            e.getPresentation().setText(SpaceBundle.message("review.checkout.action.checkout.dialog.title", objectArray));
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        MergeRequestDetailsVm mergeRequestDetailsVm = SpaceReviewCheckoutBranchActionKt.access$getMergeRequestVm(e);
        if (mergeRequestDetailsVm == null) {
            return;
        }
        MergeRequestDetailsVm detailsVm = mergeRequestDetailsVm;
        SpaceRepoInfo spaceRepoInfo = detailsVm.getRepoInfo().getValue();
        if (spaceRepoInfo == null) {
            return;
        }
        SpaceRepoInfo repoInfo2 = spaceRepoInfo;
        GitRepository gitRepository = repoInfo2.getRepository();
        List gitRepositories = CollectionsKt.listOf((Object)gitRepository);
        MergeRequestBranchPair branchPair2 = detailsVm.getBranchPairProp().getValue();
        MergeRequestBranch mergeRequestBranch = branchPair2.getSourceBranchInfo();
        if (mergeRequestBranch == null) {
            return;
        }
        MergeRequestBranch sourceBranchInfo2 = mergeRequestBranch;
        SpaceStatsCounterCollector.CHECKOUT_BRANCH.log();
        GitLocalBranch localBranch = detailsVm.getMergeRequestBranchInfoProp().getValue().getLocalBranch();
        if (localBranch != null) {
            this.checkoutLocalBranch(project3, detailsVm, localBranch, gitRepositories);
        } else {
            GitStandardRemoteBranch remoteBranch = new GitStandardRemoteBranch(repoInfo2.getRemote(), CodeReviewServiceKt.getSourceBranchName(branchPair2));
            Object[] objectArray = new Object[]{remoteBranch.getName()};
            GitNewBranchOptions gitNewBranchOptions = GitBranchUtil.getNewBranchNameFromUser((Project)project3, (Collection)gitRepositories, (String)SpaceBundle.message("review.checkout.action.checkout.dialog.title", objectArray), (String)CodeReviewServiceKt.getSourceBranchName(branchPair2), (boolean)false);
            if (gitNewBranchOptions == null) {
                return;
            }
            GitNewBranchOptions options2 = gitNewBranchOptions;
            if (options2.shouldCheckout()) {
                this.checkoutRemoteBranch(project3, detailsVm, gitRepository, repoInfo2, sourceBranchInfo2, options2, gitRepositories);
            } else {
                Object[] objectArray2 = new Object[]{detailsVm.getReviewKey()};
                String string2 = SpaceBundle.message("review.checkout.action.progress.title.creating.branch", objectArray2);
                new Task.Backgroundable(project3, gitRepository, repoInfo2, options2, sourceBranchInfo2, string2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GitRepository $gitRepository;
                    final /* synthetic */ SpaceRepoInfo $repoInfo;
                    final /* synthetic */ GitNewBranchOptions $options;
                    final /* synthetic */ MergeRequestBranch $sourceBranchInfo;
                    {
                        this.$project = $project;
                        this.$gitRepository = $gitRepository;
                        this.$repoInfo = $repoInfo;
                        this.$options = $options;
                        this.$sourceBranchInfo = $sourceBranchInfo;
                        super($project, $super_call_param$1, true);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        Git git = Git.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance()");
                        Git git2 = git;
                        GitFetchSupport.fetchSupport((Project)this.$project).fetch(this.$gitRepository, this.$repoInfo.getRemote()).throwExceptionIfFailed();
                        new GitBranchWorker(this.$project, git2, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, indicator)).createBranch(this.$options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$gitRepository, (Object)this.$sourceBranchInfo.getRef())));
                        this.$gitRepository.update();
                    }
                }.queue();
            }
        }
    }

    private final void checkoutRemoteBranch(Project project2, MergeRequestDetailsVm detailsVm, GitRepository gitRepository, SpaceRepoInfo repoInfo2, MergeRequestBranch sourceBranchInfo2, GitNewBranchOptions options2, List<? extends GitRepository> gitRepositories) {
        Object[] objectArray = new Object[]{detailsVm.getReviewKey()};
        String string2 = SpaceBundle.message("review.checkout.action.progress.title.checking.out.branch", objectArray);
        new Task.Backgroundable(project2, gitRepository, repoInfo2, sourceBranchInfo2, options2, gitRepositories, string2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitRepository $gitRepository;
            final /* synthetic */ SpaceRepoInfo $repoInfo;
            final /* synthetic */ MergeRequestBranch $sourceBranchInfo;
            final /* synthetic */ GitNewBranchOptions $options;
            final /* synthetic */ List<GitRepository> $gitRepositories;
            {
                this.$project = $project;
                this.$gitRepository = $gitRepository;
                this.$repoInfo = $repoInfo;
                this.$sourceBranchInfo = $sourceBranchInfo;
                this.$options = $options;
                this.$gitRepositories = $gitRepositories;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance()");
                Git git2 = git;
                GitFetchSupport.fetchSupport((Project)this.$project).fetch(this.$gitRepository, this.$repoInfo.getRemote()).throwExceptionIfFailed();
                GitStandardRemoteBranch remoteBranch = new GitStandardRemoteBranch(this.$repoInfo.getRemote(), this.$sourceBranchInfo.getDisplayName());
                new GitBranchWorker(this.$project, git2, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, indicator)).checkoutNewBranchStartingFrom(this.$options.getName(), remoteBranch.getName(), this.$gitRepositories);
                this.$gitRepository.update();
            }
        }.queue();
    }

    private final void checkoutLocalBranch(Project project2, MergeRequestDetailsVm detailsVm, GitLocalBranch localBranch, List<? extends GitRepository> gitRepositories) {
        Object[] objectArray = new Object[]{detailsVm.getReviewKey()};
        String string2 = SpaceBundle.message("review.checkout.action.progress.title.checking.out.branch", objectArray);
        new Task.Backgroundable(project2, localBranch, gitRepositories, string2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitLocalBranch $localBranch;
            final /* synthetic */ List<GitRepository> $gitRepositories;
            {
                this.$project = $project;
                this.$localBranch = $localBranch;
                this.$gitRepositories = $gitRepositories;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance()");
                Git git2 = git;
                new GitBranchWorker(this.$project, git2, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, indicator)).checkout(this.$localBranch.getName(), false, this.$gitRepositories);
            }
        }.queue();
    }
}

