/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class LocalDateDeserializer
extends JodaDateDeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT);
    }

    public LocalDateDeserializer(JacksonJodaDateFormat format2) {
        super(LocalDate.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new LocalDateDeserializer(format2);
    }

    public LocalDate deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
            case 1: {
                return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, (JsonDeserializer)this, this.handledType()));
            }
        }
        if (p2.isExpectedStartArrayToken()) {
            return this._fromArray(p2, ctxt);
        }
        return (LocalDate)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected String, Number or JSON Array", new Object[0]);
    }

    protected LocalDate _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (LocalDate)this._fromEmptyString(p2, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value2));
        }
        return this._format.createParser(ctxt).parseLocalDate(value2);
    }

    protected LocalDate _fromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        int day;
        int month;
        int year = p2.nextIntValue(-1);
        if (year == -1) {
            year = this._parseIntPrimitive(p2, ctxt);
        }
        if ((month = p2.nextIntValue(-1)) == -1) {
            month = this._parseIntPrimitive(p2, ctxt);
        }
        if ((day = p2.nextIntValue(-1)) == -1) {
            day = this._parseIntPrimitive(p2, ctxt);
        }
        if (p2.nextToken() != JsonToken.END_ARRAY) {
            throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.END_ARRAY, "after LocalDate ints");
        }
        return new LocalDate(year, month, day);
    }

    protected LocalDate _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new LocalDate(ts, tz);
    }
}

