/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.WeekDayTimeInterval;
import circlet.platform.api.Weekday;
import circlet.platform.api.WeekdayFormat;
import circlet.platform.api.Workday;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.Math;
import runtime.date.TimeInterval;
import runtime.date.TimeOfDay;
import runtime.date.TimeOfDayKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000f\u001a\u0012\u0010#\u001a\u00020 *\u00020\u000f2\u0006\u0010$\u001a\u00020%\u001a\u0014\u0010&\u001a\u0004\u0018\u00010 *\u00020\u000b2\u0006\u0010'\u001a\u00020 \u001a\n\u0010\"\u001a\u00020\u000f*\u00020\u0002\u001a\f\u0010\"\u001a\u0004\u0018\u00010\u000f*\u00020 \u001a\u000e\u0010\"\u001a\u00020\u000f*\u00060(j\u0002`)\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0004\"\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0004\"\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006*"}, d2={"DefaultNotificationDays", "", "", "getDefaultNotificationDays", "()Ljava/util/Set;", "DefaultNotificationHoursInterval", "Lruntime/date/TimeInterval;", "getDefaultNotificationHoursInterval", "()Lruntime/date/TimeInterval;", "DefaultNotificationWeekHours", "", "Lcirclet/platform/api/WeekDayTimeInterval;", "getDefaultNotificationWeekHours", "()Ljava/util/List;", "DefaultWeekends", "Lcirclet/platform/api/Weekday;", "getDefaultWeekends", "DefaultWorkingDays", "getDefaultWorkingDays", "DefaultWorkingHoursInterval", "getDefaultWorkingHoursInterval", "DefaultWorkingWeekHours", "getDefaultWorkingWeekHours", "convertWorkingDaysToHours", "", "days", "", "Lcirclet/platform/api/Workday;", "timeInterval", "([Lcirclet/platform/api/Workday;Lruntime/date/TimeInterval;)Ljava/util/Map;", "iCalToWeekday", "it", "", "weekdayToICal", "weekday", "title", "format", "Lcirclet/platform/api/WeekdayFormat;", "validate", "intervalName", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "platform-api"})
@SourceDebugExtension(value={"SMAP\nWorkingDays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkingDays.kt\ncirclet/platform/api/WorkingDaysKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1#2:160\n3792#3:147\n4307#3,2:148\n1603#4,9:150\n1855#4:159\n1856#4:161\n1612#4:162\n1179#4,2:163\n1253#4,4:165\n766#4:169\n857#4,2:170\n1549#4:172\n1620#4,3:173\n766#4:176\n857#4,2:177\n1549#4:179\n1620#4,3:180\n*S KotlinDebug\n*F\n+ 1 WorkingDays.kt\ncirclet/platform/api/WorkingDaysKt\n*L\n113#1:160\n112#1:147\n112#1:148,2\n113#1:150,9\n113#1:159\n113#1:161\n113#1:162\n124#1:163,2\n124#1:165,4\n95#1:169\n95#1:170,2\n95#1:172\n95#1:173,3\n108#1:176\n108#1:177,2\n108#1:179\n108#1:180,3\n*E\n"})
public final class WorkingDaysKt {
    @NotNull
    private static final TimeInterval DefaultWorkingHoursInterval;
    @NotNull
    private static final List<WeekDayTimeInterval> DefaultWorkingWeekHours;
    @NotNull
    private static final Set<Integer> DefaultWorkingDays;
    @NotNull
    private static final Set<Weekday> DefaultWeekends;
    @NotNull
    private static final TimeInterval DefaultNotificationHoursInterval;
    @NotNull
    private static final List<WeekDayTimeInterval> DefaultNotificationWeekHours;
    @NotNull
    private static final Set<Integer> DefaultNotificationDays;

    @NotNull
    public static final String title(@NotNull Weekday $this$title, @NotNull WeekdayFormat format2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$title, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format2), (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format2.ordinal()]) {
            case 1: {
                string2 = $this$title.getTitle();
                break;
            }
            case 2: {
                String string3 = $this$title.getTitle().substring(0, 3);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break;
            }
            case 3: {
                string2 = WorkingDaysKt.weekdayToICal($this$title);
                break;
            }
            case 4: {
                string2 = String.valueOf(StringsKt.first((CharSequence)$this$title.getTitle()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public static final Weekday weekday(int $this$weekday) {
        Weekday weekday;
        switch (Math.INSTANCE.floorMod($this$weekday, 7)) {
            case 0: {
                weekday = Weekday.SUNDAY;
                break;
            }
            case 1: {
                weekday = Weekday.MONDAY;
                break;
            }
            case 2: {
                weekday = Weekday.TUESDAY;
                break;
            }
            case 3: {
                weekday = Weekday.WEDNESDAY;
                break;
            }
            case 4: {
                weekday = Weekday.THURSDAY;
                break;
            }
            case 5: {
                weekday = Weekday.FRIDAY;
                break;
            }
            case 6: {
                weekday = Weekday.SATURDAY;
                break;
            }
            default: {
                throw new IllegalStateException(("can't calculate a weekday number " + $this$weekday).toString());
            }
        }
        return weekday;
    }

    @Nullable
    public static final Weekday weekday(@NotNull String $this$weekday) {
        Weekday weekday;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
            Weekday[] weekdayArray = Weekday.values();
            int n = weekdayArray.length;
            for (int i = 0; i < n; ++i) {
                Weekday weekday2;
                Weekday it = weekday2 = weekdayArray[i];
                boolean bl = false;
                if (!StringsKt.equals((String)it.getTitle(), (String)$this$weekday, (boolean)true)) continue;
                weekday = weekday2;
                break block1;
            }
            weekday = null;
        }
        return weekday;
    }

    @NotNull
    public static final Weekday weekday(@NotNull DayOfWeek $this$weekday) {
        Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
        return Weekday.valueOf($this$weekday.name());
    }

    @NotNull
    public static final String weekdayToICal(@NotNull Weekday weekday) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)weekday, (String)"weekday");
        switch (WhenMappings.$EnumSwitchMapping$1[weekday.ordinal()]) {
            case 1: {
                string2 = "SU";
                break;
            }
            case 2: {
                string2 = "MO";
                break;
            }
            case 3: {
                string2 = "TU";
                break;
            }
            case 4: {
                string2 = "WE";
                break;
            }
            case 5: {
                string2 = "TH";
                break;
            }
            case 6: {
                string2 = "FR";
                break;
            }
            case 7: {
                string2 = "SA";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Nullable
    public static final Weekday iCalToWeekday(@NotNull String it) {
        Weekday weekday;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        switch (it) {
            case "SU": {
                weekday = Weekday.SUNDAY;
                break;
            }
            case "MO": {
                weekday = Weekday.MONDAY;
                break;
            }
            case "TU": {
                weekday = Weekday.TUESDAY;
                break;
            }
            case "WE": {
                weekday = Weekday.WEDNESDAY;
                break;
            }
            case "TH": {
                weekday = Weekday.THURSDAY;
                break;
            }
            case "FR": {
                weekday = Weekday.FRIDAY;
                break;
            }
            case "SA": {
                weekday = Weekday.SATURDAY;
                break;
            }
            default: {
                weekday = null;
            }
        }
        return weekday;
    }

    @NotNull
    public static final TimeInterval getDefaultWorkingHoursInterval() {
        return DefaultWorkingHoursInterval;
    }

    @NotNull
    public static final List<WeekDayTimeInterval> getDefaultWorkingWeekHours() {
        return DefaultWorkingWeekHours;
    }

    @NotNull
    public static final Set<Integer> getDefaultWorkingDays() {
        return DefaultWorkingDays;
    }

    @NotNull
    public static final Set<Weekday> getDefaultWeekends() {
        return DefaultWeekends;
    }

    @NotNull
    public static final TimeInterval getDefaultNotificationHoursInterval() {
        return DefaultNotificationHoursInterval;
    }

    @NotNull
    public static final List<WeekDayTimeInterval> getDefaultNotificationWeekHours() {
        return DefaultNotificationWeekHours;
    }

    @NotNull
    public static final Set<Integer> getDefaultNotificationDays() {
        return DefaultNotificationDays;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Integer, TimeInterval> convertWorkingDaysToHours(@NotNull Workday[] days, @NotNull TimeInterval timeInterval) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)days, (String)"days");
        Intrinsics.checkNotNullParameter((Object)timeInterval, (String)"timeInterval");
        Workday[] $this$filter$iv = days;
        boolean $i$f$filter = false;
        Workday[] workdayArray = $this$filter$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
            void it = element$iv$iv2;
            boolean bl = false;
            if (!it.getWorking()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            Workday it = (Workday)element$iv$iv3;
            boolean bl2 = false;
            Weekday weekday = WorkingDaysKt.weekday(it.getWeekday());
            if (weekday == null) {
                pair = null;
            } else {
                int day = weekday.getOrderNumber();
                TimeOfDay since = timeInterval.getSince();
                int hoursTill = since.getHours() + it.getHours() + 1;
                TimeOfDay till = hoursTill > 23 ? new TimeOfDay(23, 59, null, 4, null) : new TimeOfDay(hoursTill, 0, null, 6, null);
                pair = TuplesKt.to((Object)day, (Object)new TimeInterval(since, till));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Iterator element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public static final String validate(@NotNull WeekDayTimeInterval $this$validate, @NotNull String intervalName) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intervalName, (String)"intervalName");
        if (!$this$validate.getChecked()) {
            return null;
        }
        String string2 = TimeOfDayKt.validate($this$validate.getInterval().getSince());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return intervalName + " interval start " + $this$validate.getInterval().getSince() + " is invalid: " + it;
        }
        string2 = TimeOfDayKt.validate($this$validate.getInterval().getTill());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return intervalName + " interval end " + $this$validate.getInterval().getTill() + " is invalid: " + it;
        }
        return $this$validate.getInterval().getSince().compareTo($this$validate.getInterval().getTill()) >= 0 ? intervalName + " period " + TimeOfDayKt.format($this$validate.getInterval()) + " is invalid" : null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean bl;
        WeekDayTimeInterval it;
        Object[] $this$filterTo$iv$iv;
        DefaultWorkingHoursInterval = new TimeInterval(new TimeOfDay(9, 0, null, 6, null), new TimeOfDay(18, 0, null, 6, null));
        Object[] objectArray = new WeekDayTimeInterval[]{new WeekDayTimeInterval(Weekday.MONDAY.getOrderNumber(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.TUESDAY.getOrderNumber(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.WEDNESDAY.getOrderNumber(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.THURSDAY.getOrderNumber(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.FRIDAY.getOrderNumber(), true, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.SATURDAY.getOrderNumber(), false, DefaultWorkingHoursInterval), new WeekDayTimeInterval(Weekday.SUNDAY.getOrderNumber(), false, DefaultWorkingHoursInterval)};
        DefaultWorkingWeekHours = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$filter$iv = DefaultWorkingWeekHours;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            bl = false;
            if (!it.getChecked()) continue;
            destination$iv$iv.add(t);
        }
        Object $this$map$iv = (Object[])((List)destination$iv$iv);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.getDay());
        }
        DefaultWorkingDays = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = new Weekday[]{Weekday.SATURDAY, Weekday.SUNDAY};
        DefaultWeekends = SetsKt.setOf((Object[])$this$map$iv);
        DefaultNotificationHoursInterval = new TimeInterval(new TimeOfDay(8, 0, null, 6, null), new TimeOfDay(20, 0, null, 6, null));
        $this$map$iv = new WeekDayTimeInterval[]{new WeekDayTimeInterval(Weekday.MONDAY.getOrderNumber(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.TUESDAY.getOrderNumber(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.WEDNESDAY.getOrderNumber(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.THURSDAY.getOrderNumber(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.FRIDAY.getOrderNumber(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.SATURDAY.getOrderNumber(), true, DefaultNotificationHoursInterval), new WeekDayTimeInterval(Weekday.SUNDAY.getOrderNumber(), true, DefaultNotificationHoursInterval)};
        DefaultNotificationWeekHours = CollectionsKt.listOf((Object[])$this$map$iv);
        $this$filter$iv = DefaultNotificationWeekHours;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            bl = false;
            if (!it.getChecked()) continue;
            destination$iv$iv.add(t);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (WeekDayTimeInterval)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.getDay());
        }
        DefaultNotificationDays = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WeekdayFormat.values().length];
            try {
                nArray[WeekdayFormat.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekdayFormat.MEDIUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekdayFormat.ICAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeekdayFormat.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Weekday.values().length];
            try {
                nArray[Weekday.SUNDAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.MONDAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.TUESDAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.WEDNESDAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.THURSDAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.FRIDAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weekday.SATURDAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

