/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.SpecIntersectsKt;
import circlet.common.calendar.TimeInterval;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.PrimitivesExKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0000J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00002\u0006\u0010\r\u001a\u00020\u0000J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u0014R\u0015\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcirclet/common/calendar/ClosedTimeInterval;", "Lcirclet/common/calendar/TimeInterval;", "start", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "endInclusive", "(Lcirclet/platform/api/KotlinXDateTime;Lcirclet/platform/api/KotlinXDateTime;)V", "closedEndExclusive", "getClosedEndExclusive", "()Lcirclet/platform/api/KotlinXDateTime;", "closedEndInclusive", "getClosedEndInclusive", "add", "interval", "contains", "", "intersection", "splitByDates", "", "timezone", "Lcirclet/platform/api/ATimeZone;", "toMinutesRangeInZone", "Lkotlin/ranges/ClosedRange;", "", "common"})
@SourceDebugExtension(value={"SMAP\nEventCounters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventCounters.kt\ncirclet/common/calendar/ClosedTimeInterval\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KLogger.kt\nlibraries/klogging/KLogger\n*L\n1#1,876:1\n1#2:877\n28#3,5:878\n28#3,5:883\n*S KotlinDebug\n*F\n+ 1 EventCounters.kt\ncirclet/common/calendar/ClosedTimeInterval\n*L\n814#1:878,5\n824#1:883,5\n*E\n"})
public final class ClosedTimeInterval
extends TimeInterval {
    @NotNull
    private final KotlinXDateTime closedEndInclusive;
    @NotNull
    private final KotlinXDateTime closedEndExclusive;

    public ClosedTimeInterval(@NotNull KotlinXDateTime start2, @NotNull KotlinXDateTime endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        super(start2, endInclusive);
        KotlinXDateTime kotlinXDateTime = this.getEndInclusive();
        Intrinsics.checkNotNull((Object)kotlinXDateTime);
        this.closedEndInclusive = kotlinXDateTime;
        KotlinXDateTime kotlinXDateTime2 = this.getEndExclusive();
        Intrinsics.checkNotNull((Object)kotlinXDateTime2);
        this.closedEndExclusive = kotlinXDateTime2;
    }

    @NotNull
    public final KotlinXDateTime getClosedEndInclusive() {
        return this.closedEndInclusive;
    }

    @NotNull
    public final KotlinXDateTime getClosedEndExclusive() {
        return this.closedEndExclusive;
    }

    @Nullable
    public final ClosedTimeInterval intersection(@NotNull ClosedTimeInterval interval2) {
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        KotlinXDateTime[] kotlinXDateTimeArray = new KotlinXDateTime[]{this.getStart(), interval2.getStart()};
        KotlinXDateTime intersectionStart = EventCountersKt.access$maxTime(kotlinXDateTimeArray);
        KotlinXDateTime[] kotlinXDateTimeArray2 = new KotlinXDateTime[]{this.closedEndInclusive, interval2.closedEndInclusive};
        KotlinXDateTime intersectionEnd = EventCountersKt.access$minTime(kotlinXDateTimeArray2);
        return intersectionStart.compareTo(intersectionEnd) < 0 ? new ClosedTimeInterval(intersectionStart, intersectionEnd) : null;
    }

    public final boolean contains(@NotNull ClosedTimeInterval interval2) {
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        return ADateJvmKt.getMillis(this.getStart()) <= ADateJvmKt.getMillis(interval2.getStart()) && ADateJvmKt.getMillis(this.closedEndInclusive) >= ADateJvmKt.getMillis(interval2.closedEndInclusive);
    }

    @NotNull
    public final ClosedTimeInterval add(@NotNull ClosedTimeInterval interval2) {
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        KotlinXDateTime[] kotlinXDateTimeArray = new KotlinXDateTime[]{this.getStart(), interval2.getStart()};
        KotlinXDateTime start2 = EventCountersKt.access$minTime(kotlinXDateTimeArray);
        KotlinXDateTime[] kotlinXDateTimeArray2 = new KotlinXDateTime[]{this.closedEndInclusive, interval2.closedEndInclusive};
        KotlinXDateTime end = EventCountersKt.access$maxTime(kotlinXDateTimeArray2);
        return new ClosedTimeInterval(start2, end);
    }

    @NotNull
    public final ClosedRange<Integer> toMinutesRangeInZone(@NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        int duration = ADateKt.minutesDifference(this.getStart(), this.closedEndInclusive);
        if (!(duration > 0)) {
            boolean $i$a$-require-ClosedTimeInterval$toMinutesRangeInZone$22 = false;
            String $i$a$-require-ClosedTimeInterval$toMinutesRangeInZone$22 = "incorrect time range: " + this + ", duration is " + duration;
            throw new IllegalArgumentException($i$a$-require-ClosedTimeInterval$toMinutesRangeInZone$22.toString());
        }
        int startMinute = ADateJvmKt.getMinuteOfDay(ADateJvmKt.withZone(this.getStart(), timezone));
        int endInclusive = startMinute + duration;
        return (ClosedRange)new IntRange(startMinute, endInclusive);
    }

    @NotNull
    public final List<ClosedTimeInterval> splitByDates(@NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        KotlinXDateTime startTime = ADateJvmKt.withZone(this.getStart(), timezone);
        KotlinXDateTime endTime = ADateJvmKt.withZone(this.closedEndInclusive, timezone);
        KotlinXDate endDate = ADateJvmKt.toDate(endTime);
        KotlinXDateTime currentTime = null;
        currentTime = startTime;
        List datesIntervals = new ArrayList();
        while (PrimitivesExKt.isBefore(ADateJvmKt.toDate(currentTime), endDate)) {
            KotlinXDateTime splitTime = ADateJvmKt.withZone(ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.plusDays(ADateJvmKt.toDate(currentTime), 1), timezone), timezone);
            KotlinXDateTime lastMinuteOfDay = ADateJvmKt.plusMinutes(splitTime, -1);
            if (ADateJvmKt.getMillis(currentTime) <= ADateJvmKt.getMillis(lastMinuteOfDay)) {
                datesIntervals.add(new ClosedTimeInterval(currentTime, lastMinuteOfDay));
            } else {
                KLogger this_$iv = SpecIntersectsKt.getLog();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    boolean bl = false;
                    String msgStr$iv = "Time interval duration is less than a minute, interval is skipped: " + ADateJvmKt.formatFullDateTime(currentTime) + " - " + ADateJvmKt.formatFullDateTime(lastMinuteOfDay) + ".Event start time = " + ADateJvmKt.formatFullDateTime(startTime) + ", event end inclusive time = " + ADateJvmKt.formatFullDateTime(endTime) + ", splitting by dates in timezone " + timezone.getId();
                    this_$iv.warn(msgStr$iv);
                }
            }
            currentTime = splitTime;
        }
        if (ADateJvmKt.getMillis(currentTime) < ADateJvmKt.getMillis(endTime)) {
            datesIntervals.add(new ClosedTimeInterval(currentTime, endTime));
        } else {
            KLogger this_$iv = SpecIntersectsKt.getLog();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                boolean bl = false;
                String msgStr$iv = "Negative time interval: " + ADateJvmKt.formatFullDateTime(currentTime) + " - " + ADateJvmKt.formatFullDateTime(endTime) + ". Event start time = " + ADateJvmKt.formatFullDateTime(startTime) + ", event end inclusive time = " + ADateJvmKt.formatFullDateTime(endTime) + ", splitting by dates in timezone " + timezone.getId();
                this_$iv.warn(msgStr$iv);
            }
        }
        return datesIntervals;
    }
}

