/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IronPythonSdkFlavor
extends PythonSdkFlavor<PyFlavorData.Empty> {
    public static final Pattern VERSION_RE = Pattern.compile("\\w+ ([0-9\\.]+).*");

    private IronPythonSdkFlavor() {
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @NotNull
    public String envPathParam() {
        return "IRONPYTHONPATH";
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        File[] dirs;
        TreeSet<String> result2 = new TreeSet<String>();
        String root = System.getenv("ProgramFiles(x86)");
        if (root == null) {
            root = System.getenv("ProgramFiles");
        }
        if (root != null && (dirs = new File(root).listFiles()) != null) {
            for (File dir : dirs) {
                File ipy;
                if (!dir.getName().startsWith("IronPython") || !(ipy = new File(dir, "ipy.exe")).exists()) continue;
                result2.add(ipy.getPath());
            }
        }
        WinPythonSdkFlavor.findInPath(result2, "ipy.exe");
        WinPythonSdkFlavor.findInPath(result2, "ipy64.exe");
        List list = ContainerUtil.map(result2, x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        String name2;
        if (file == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return (name2 = file.getName()).equals("ipy.exe") || name2.equals("ipy64.exe");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output2) {
        String match;
        if (output2 == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        return (match = PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output2)), (Pattern)VERSION_RE)) != null ? this.getName() + " " + match : null;
    }

    @Override
    @NotNull
    public Collection<String> getExtraDebugOptions() {
        List<String> list = Collections.singletonList("-X:Frames");
        if (list == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void initPythonPath(@NotNull GeneralCommandLine cmd, boolean passParentEnvs, @NotNull Collection<String> path2) {
        if (cmd == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if (path2 == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        this.initPythonPath(path2, passParentEnvs, cmd.getEnvironment());
    }

    @Override
    public void initPythonPath(@NotNull Collection<String> path2, boolean passParentEnvs, @NotNull Map<String, String> env) {
        if (path2 == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(6);
        }
        if (env == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(7);
        }
        PythonEnvUtil.addToEnv("IRONPYTHONPATH", StringUtil.join(path2, (String)File.pathSeparator), env);
    }

    @Override
    @NotNull
    public String getName() {
        return "IronPython";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Dotnet;
        if (icon == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(8);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraDebugOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

