/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyVirtualEnvReader;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PySdkUtil {
    private static final Logger LOG = Logger.getInstance(PySdkUtil.class);
    public static final int SUBSTITUTE = 26;
    public static final String PATH_ENV_VARIABLE = "PATH";
    private static final Key<Map<String, String>> ENVIRONMENT_KEY = Key.create((String)"ENVIRONMENT_KEY");

    private PySdkUtil() {
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command) {
        return PySdkUtil.getProcessOutput(homePath2, command, -1);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command, int timeout) {
        return PySdkUtil.getProcessOutput(homePath2, command, null, timeout);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        return PySdkUtil.getProcessOutput(homePath2, command, extraEnv, timeout, null, true);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout, byte @Nullable [] stdin, boolean needEOFMarker) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(new GeneralCommandLine(command), homePath2, extraEnv, timeout, stdin, needEOFMarker);
        if (processOutput == null) {
            PySdkUtil.$$$reportNull$$$0(0);
        }
        return processOutput;
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath2, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        if (cmd == null) {
            PySdkUtil.$$$reportNull$$$0(1);
        }
        return PySdkUtil.getProcessOutput(cmd, homePath2, extraEnv, timeout, null, true);
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath2, @Nullable @NonNls Map<String, String> extraEnv, int timeout, byte @Nullable [] stdin, boolean needEOFMarker) {
        if (cmd == null) {
            PySdkUtil.$$$reportNull$$$0(2);
        }
        if (homePath2 == null || !new File(homePath2).exists()) {
            return new ProcessOutput();
        }
        Map<String, String> systemEnv = System.getenv();
        Map<String, String> expandedCmdEnv = PySdkUtil.mergeEnvVariables(systemEnv, cmd.getEnvironment());
        Map<String, String> env = extraEnv != null ? PySdkUtil.mergeEnvVariables(expandedCmdEnv, extraEnv) : expandedCmdEnv;
        PythonEnvUtil.resetHomePathChanges(homePath2, env);
        try {
            CommandLinePatcher cmdLinePatcher;
            GeneralCommandLine commandLine = cmd.withWorkDirectory(homePath2).withEnvironment(env);
            PythonSdkFlavor<?> flavor = PythonSdkFlavor.getFlavor(commandLine.getExePath());
            CommandLinePatcher commandLinePatcher = cmdLinePatcher = flavor != null ? flavor.commandLinePatcher() : null;
            if (cmdLinePatcher != null) {
                cmdLinePatcher.patchCommandLine(cmd);
            }
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            if (stdin != null) {
                OutputStream processInput = processHandler.getProcessInput();
                assert (processInput != null);
                processInput.write(stdin);
                if (SystemInfo.isWindows && needEOFMarker) {
                    processInput.write(26);
                    processInput.flush();
                } else {
                    processInput.close();
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                ProgressManager progressManager = ProgressManager.getInstance();
                Application application = ApplicationManager.getApplication();
                assert (application.isUnitTestMode() || application.isHeadlessEnvironment() || !application.isWriteAccessAllowed()) : "Background task can't be run under write action";
                return (ProcessOutput)progressManager.runProcessWithProgressSynchronously(() -> processHandler.runProcess(timeout), PySdkBundle.message("python.sdk.run.wait", new Object[0]), false, null);
            }
            return processHandler.runProcess();
        }
        catch (ExecutionException | IOException e) {
            return PySdkUtil.getOutputForException((Exception)e);
        }
    }

    private static ProcessOutput getOutputForException(final Exception e) {
        LOG.warn((Throwable)e);
        return new ProcessOutput(){

            @NotNull
            public String getStderr() {
                Object err = super.getStderr();
                err = !StringUtil.isEmpty((String)err) ? (String)err + "\n" + e.getMessage() : e.getMessage();
                String string = err;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil$1", "getStderr"));
            }
        };
    }

    @NotNull
    public static Map<String, String> mergeEnvVariables(@NotNull Map<String, String> environment, @NotNull Map<String, String> extraEnvironment) {
        if (environment == null) {
            PySdkUtil.$$$reportNull$$$0(3);
        }
        if (extraEnvironment == null) {
            PySdkUtil.$$$reportNull$$$0(4);
        }
        HashMap<String, String> result2 = new HashMap<String, String>(environment);
        for (Map.Entry<String, String> entry : extraEnvironment.entrySet()) {
            String name2 = entry.getKey();
            if (PATH_ENV_VARIABLE.equals(name2) || "PYTHONPATH".equals(name2)) {
                PythonEnvUtil.addPathToEnv(result2, name2, entry.getValue());
                continue;
            }
            result2.put(name2, entry.getValue());
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            PySdkUtil.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull Sdk sdk2) {
        Map cached;
        if (sdk2 == null) {
            PySdkUtil.$$$reportNull$$$0(6);
        }
        if ((cached = (Map)sdk2.getUserData(ENVIRONMENT_KEY)) != null) {
            Map map = cached;
            if (map == null) {
                PySdkUtil.$$$reportNull$$$0(7);
            }
            return map;
        }
        String sdkHome = sdk2.getHomePath();
        if (sdkHome == null || sdkHome.trim().isEmpty()) {
            LOG.warn("homePath is null or empty, skipping env loading for " + sdk2.getName());
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                PySdkUtil.$$$reportNull$$$0(8);
            }
            return map;
        }
        PythonSdkAdditionalData additionalData = (PythonSdkAdditionalData)ObjectUtils.tryCast((Object)sdk2.getSdkAdditionalData(), PythonSdkAdditionalData.class);
        if (additionalData == null) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                PySdkUtil.$$$reportNull$$$0(9);
            }
            return map;
        }
        Map<String, String> environment = PySdkUtil.activateVirtualEnv(sdkHome);
        sdk2.putUserData(ENVIRONMENT_KEY, environment);
        Map<String, String> map = environment;
        if (map == null) {
            PySdkUtil.$$$reportNull$$$0(10);
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull String sdkHome) {
        PyVirtualEnvReader reader;
        if (sdkHome == null) {
            PySdkUtil.$$$reportNull$$$0(11);
        }
        if ((reader = new PyVirtualEnvReader(sdkHome)).getActivate() != null) {
            Map<String, String> map;
            try {
                map = Collections.unmodifiableMap(PyVirtualEnvReader.Companion.filterVirtualEnvVars(reader.readPythonEnv()));
            }
            catch (Exception e) {
                LOG.error("Couldn't read virtualenv variables", (Throwable)e);
            }
            if (map == null) {
                PySdkUtil.$$$reportNull$$$0(12);
            }
            return map;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            PySdkUtil.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk2) {
        PythonSdkFlavor<?> flavor;
        if (sdk2 != null && PythonSdkUtil.isPythonSdk(sdk2) && (flavor = PythonSdkFlavor.getFlavor(sdk2)) != null) {
            LanguageLevel languageLevel = flavor.getLanguageLevel(sdk2);
            if (languageLevel == null) {
                PySdkUtil.$$$reportNull$$$0(14);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PySdkUtil.$$$reportNull$$$0(15);
        }
        return languageLevel;
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PySdkUtil.$$$reportNull$$$0(16);
        }
        String string = PyBuiltinCache.getBuiltinsFileName(PySdkUtil.getLanguageLevelForSdk(sdk2));
        if (string == null) {
            PySdkUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public static Sdk findSdkForDirectory(@NotNull Project project, @NotNull Path workingDirectory, boolean allowRemote) {
        Sdk sdk2;
        VirtualFile workingDirectoryVirtualFile;
        if (project == null) {
            PySdkUtil.$$$reportNull$$$0(18);
        }
        if (workingDirectory == null) {
            PySdkUtil.$$$reportNull$$$0(19);
        }
        if ((workingDirectoryVirtualFile = LocalFileSystem.getInstance().findFileByNioFile(workingDirectory)) != null && (sdk2 = PySdkUtil.getLocalSdkForFile(project, workingDirectoryVirtualFile, allowRemote)) != null) {
            return sdk2;
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk3 = PythonSdkUtil.findPythonSdk(m);
            if (sdk3 == null || !allowRemote && PythonSdkUtil.isRemote(sdk3)) continue;
            return sdk3;
        }
        return null;
    }

    @Nullable
    private static Sdk getLocalSdkForFile(@NotNull Project project, @NotNull VirtualFile workingDirectoryVirtualFile, boolean allowRemote) {
        Sdk sdk2;
        Module module;
        if (project == null) {
            PySdkUtil.$$$reportNull$$$0(20);
        }
        if (workingDirectoryVirtualFile == null) {
            PySdkUtil.$$$reportNull$$$0(21);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)workingDirectoryVirtualFile, (Project)project)) != null && (sdk2 = PythonSdkUtil.findPythonSdk(module)) != null && (allowRemote || !PythonSdkUtil.isRemote(sdk2))) {
            return sdk2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 11, 16, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvironment";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectoryVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeEnvVariables";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "activateVirtualEnv";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergeEnvVariables";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "activateVirtualEnv";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSdkForDirectory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSdkForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 11, 16, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

