/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMapper;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteCommandLineStateUtil {
    private PyRemoteCommandLineStateUtil() {
    }

    static void patchDebugParams(@NotNull String helpersPath, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider, @NotNull ParamsGroup debugParams) throws RemoteSdkException {
        if (helpersPath == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(0);
        }
        if (remoteSocketProvider == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(1);
        }
        if (debugParams == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(2);
        }
        debugParams.getParametersList().set(0, new RemoteFile(helpersPath, "pydev/pydevd.py").getPath());
        Pair<String, Integer> socket = remoteSocketProvider.getRemoteSocket(Integer.parseInt(debugParams.getParametersList().get(PyDebugRunner.findIndex(debugParams.getParameters(), "--port"))));
        int clientParamIndex = PyDebugRunner.findIndex(debugParams.getParameters(), "--client");
        if (clientParamIndex != -1) {
            debugParams.getParametersList().set(clientParamIndex, (String)socket.getFirst());
        }
        debugParams.getParametersList().set(PyDebugRunner.findIndex(debugParams.getParameters(), "--port"), Integer.toString((Integer)socket.getSecond()));
    }

    public static void patchProfileParams(@NotNull String interpreterPath, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider, @NotNull ParamsGroup profileParams, @Nullable File workDirectory, @NotNull PathMapper pathMapper) throws RemoteSdkException {
        if (interpreterPath == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(3);
        }
        if (remoteSocketProvider == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(4);
        }
        if (profileParams == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(6);
        }
        PyCommandLineStateUtil.remapParameters(interpreterPath, pathMapper, profileParams, workDirectory);
        Pair<String, Integer> socket = remoteSocketProvider.getRemoteSocket(Integer.parseInt(profileParams.getParametersList().get(2)));
        profileParams.getParametersList().set(1, (String)socket.getFirst());
        profileParams.getParametersList().set(2, Integer.toString((Integer)socket.getSecond()));
    }

    public static void patchCoverageParams(@NotNull String interpreterPath, @NotNull ParamsGroup coverageParams, @Nullable File workDirectory, @NotNull PathMapper pathMapper) {
        if (interpreterPath == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(7);
        }
        if (coverageParams == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PyRemoteCommandLineStateUtil.$$$reportNull$$$0(9);
        }
        PyCommandLineStateUtil.remapParameters(interpreterPath, pathMapper, coverageParams, workDirectory);
        int i = 0;
        for (String param : coverageParams.getParameters()) {
            String omitPrefix;
            if (param.startsWith(omitPrefix = "--omit=")) {
                String path2 = param.substring(omitPrefix.length());
                coverageParams.getParametersList().set(i, omitPrefix + RemoteFile.detectSystemByPath((String)interpreterPath).createRemoteFile(pathMapper.convertToRemote(path2)).getPath());
            }
            ++i;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileParams";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageParams";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/remote/PyRemoteCommandLineStateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchDebugParams";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "patchProfileParams";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCoverageParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

