/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Maps;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyDictCreationInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DictCreationQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.dict.creation", new Object[0]);
        if (string == null) {
            DictCreationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            DictCreationQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            DictCreationQuickFix.$$$reportNull$$$0(2);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        LinkedHashMap statementsMap = Maps.newLinkedHashMap();
        PyAssignmentStatement myStatement = PyUtil.as(descriptor2.getPsiElement(), PyAssignmentStatement.class);
        if (myStatement == null) {
            return;
        }
        PyExpression assignedValue = myStatement.getAssignedValue();
        if (assignedValue instanceof PyDictLiteralExpression) {
            for (PsiElement expression : assignedValue.getChildren()) {
                if (expression instanceof PyKeyValueExpression) {
                    PyKeyValueExpression kvExpr = (PyKeyValueExpression)expression;
                    PyExpression value = kvExpr.getValue();
                    if (value == null) continue;
                    statementsMap.put(kvExpr.getKey().getText(), value.getText());
                    continue;
                }
                if (!(expression instanceof PyDoubleStarExpression)) continue;
                statementsMap.put(expression.getText(), null);
            }
            PyStatement statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)myStatement, PyStatement.class);
            while (statement instanceof PyAssignmentStatement) {
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)statement;
                PyExpression target = myStatement.getTargets()[0];
                String targetName = target.getName();
                if (targetName == null) continue;
                List<Pair<PyExpression, PyExpression>> targetsToValues = PyDictCreationInspection.getDictTargets(target, targetName, assignmentStatement);
                PyStatement nextStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PyStatement.class);
                if (targetsToValues == null || targetsToValues.isEmpty()) break;
                for (Pair<PyExpression, PyExpression> targetToValue : targetsToValues) {
                    PySubscriptionExpression subscription = (PySubscriptionExpression)targetToValue.first;
                    PyExpression indexExpression = subscription.getIndexExpression();
                    assert (indexExpression != null);
                    Object indexText = indexExpression instanceof PyTupleExpression ? "(" + indexExpression.getText() + ")" : indexExpression.getText();
                    Object valueText = targetToValue.second instanceof PyTupleExpression ? "(" + ((PyExpression)targetToValue.second).getText() + ")" : ((PyExpression)targetToValue.second).getText();
                    statementsMap.put(indexText, valueText);
                    statement.delete();
                }
                statement = nextStatement;
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            for (Map.Entry entry : statementsMap.entrySet()) {
                if (entry.getValue() != null) {
                    statements.add((String)entry.getKey() + ": " + (String)entry.getValue());
                    continue;
                }
                statements.add((String)entry.getKey());
            }
            PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(myStatement), "{" + StringUtil.join(statements, (String)", ") + "}");
            assignedValue.replace((PsiElement)expression);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

