/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.stubs.PyImportStatementStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportToImportFromIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.convert.import.unqualify", new Object[0]);
        if (string == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static PyImportElement findImportElement(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(2);
        }
        PsiElement elementAtCaret = file.findElementAt(editor2.getCaretModel().getOffset());
        PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PyImportElement.class);
        PyPsiUtils.assertValid((PsiElement)importElement);
        if (importElement != null && importElement.isValid()) {
            return importElement;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        IntentionState state2 = new IntentionState(editor2, file);
        if (state2.isAvailable()) {
            this.setText(state2.getText());
            return true;
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(4);
        }
        IntentionState state2 = new IntentionState(editor2, file);
        state2.invoke();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findImportElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class IntentionState {
        private String myModuleName;
        private String myQualifierName;
        private PsiElement myReferee;
        private PyImportElement myImportElement;
        private Collection<PsiReference> myReferences;
        private boolean myHasModuleReference;
        private int myRelativeLevel;

        IntentionState(@NotNull Editor editor2, @NotNull PsiFile file) {
            if (editor2 == null) {
                IntentionState.$$$reportNull$$$0(0);
            }
            if (file == null) {
                IntentionState.$$$reportNull$$$0(1);
            }
            this.myModuleName = null;
            this.myQualifierName = null;
            this.myReferee = null;
            this.myImportElement = null;
            this.myReferences = null;
            this.myHasModuleReference = false;
            boolean available = false;
            this.myImportElement = ImportToImportFromIntention.findImportElement(editor2, file);
            if (this.myImportElement != null) {
                PsiElement parent = this.myImportElement.getParent();
                if (parent instanceof PyImportStatement) {
                    this.myRelativeLevel = 0;
                    available = true;
                } else if (parent instanceof PyFromImportStatement) {
                    PyFromImportStatement fromImport = (PyFromImportStatement)parent;
                    int relativeLevel = fromImport.getRelativeLevel();
                    PyPsiUtils.assertValid((PsiElement)fromImport);
                    if (fromImport.isValid() && relativeLevel > 0 && fromImport.getImportSource() == null) {
                        this.myRelativeLevel = relativeLevel;
                        available = true;
                    }
                }
            }
            if (available) {
                this.collectReferencesAndOtherData(file);
            }
        }

        public boolean isAvailable() {
            return this.myReferences != null && this.myReferences.size() > 0;
        }

        private void collectReferencesAndOtherData(PsiFile file) {
            assert (this.myImportElement != null) : "isAvailable() must have returned true, but myImportElement is null";
            PyReferenceExpression importReference = this.myImportElement.getImportReferenceExpression();
            if (importReference != null) {
                this.myModuleName = PyPsiUtils.toPath(importReference);
                this.myQualifierName = this.myImportElement.getVisibleName();
                this.myReferee = importReference.getReference().resolve();
                this.myHasModuleReference = false;
                if (this.myReferee != null && this.myModuleName != null && this.myQualifierName != null) {
                    final ArrayList<PsiReference> references2 = new ArrayList<PsiReference>();
                    PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                        public boolean execute(@NotNull PsiElement element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (element instanceof PyReferenceExpression) {
                                PyReferenceExpression ref = (PyReferenceExpression)element;
                                if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) == null && myQualifierName.equals(PyPsiUtils.toPath(ref))) {
                                    PsiElement parentElt = ref.getParent();
                                    if (parentElt instanceof PyQualifiedExpression) {
                                        PsiElement resolved = ref.getReference().resolve();
                                        if (resolved == myReferee) {
                                            references2.add(ref.getReference());
                                        }
                                    } else {
                                        myHasModuleReference = true;
                                    }
                                }
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState$1", "execute"));
                        }
                    });
                    this.myReferences = references2;
                }
            }
        }

        public void invoke() {
            assert (this.myImportElement != null) : "isAvailable() must have returned true, but myImportElement is null";
            PyUtil.sure(this.myImportElement.getImportReferenceExpression());
            Project project = this.myImportElement.getProject();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)this.myImportElement);
            try {
                PyImportElement[] importElements;
                StubBasedPsiElement<PyImportStatementStub> importStatement;
                HashSet<String> usedNames = new HashSet<String>();
                for (PsiReference ref : this.myReferences) {
                    PsiElement elt = ref.getElement();
                    PsiElement parentElt = elt.getParent();
                    String nameUsed = PyUtil.sure(PyUtil.sure(parentElt).getLastChild()).getText();
                    usedNames.add(nameUsed);
                    if (!FileModificationService.getInstance().preparePsiElementForWrite(elt)) {
                        return;
                    }
                    assert (parentElt instanceof PyReferenceExpression) : parentElt.getClass();
                    PyExpression newReference = generator.createExpressionFromText(languageLevel, nameUsed);
                    parentElt.replace((PsiElement)newReference);
                }
                PsiElement importer = this.myImportElement.getParent();
                if (importer instanceof PyImportStatement) {
                    importStatement = (PyImportStatement)importer;
                    importElements = importStatement.getImportElements();
                } else if (importer instanceof PyFromImportStatement) {
                    importStatement = (PyFromImportStatement)importer;
                    importElements = ((PyFromImportStatement)importStatement).getImportElements();
                } else {
                    throw new IncorrectOperationException("Not an import at all");
                }
                PyFromImportStatement newImportStatement = generator.createFromImportStatement(languageLevel, this.getDots() + this.myModuleName, StringUtil.join(usedNames, (String)", "), null);
                PsiElement parent = importStatement.getParent();
                PyUtil.sure(parent);
                PyUtil.sure(parent.isValid());
                if (importElements.length == 1) {
                    if (this.myHasModuleReference) {
                        parent.addAfter((PsiElement)newImportStatement, (PsiElement)importStatement);
                    } else {
                        PyUtil.sure(parent.getNode()).replaceChild(PyUtil.sure(importStatement.getNode()), PyUtil.sure(newImportStatement.getNode()));
                    }
                } else {
                    if (!this.myHasModuleReference) {
                        for (PyImportElement pie : importElements) {
                            if (pie != this.myImportElement) continue;
                            pie.delete();
                            break;
                        }
                    }
                    parent.addAfter((PsiElement)newImportStatement, (PsiElement)importStatement);
                }
            }
            catch (IncorrectOperationException ignored) {
                PythonUiService.getInstance().showBalloonWarning(project, PyPsiBundle.message("QFIX.action.failed", new Object[0]));
            }
        }

        @NotNull
        @IntentionName
        public String getText() {
            PyReferenceExpression reference;
            String moduleName = "?";
            if (this.myImportElement != null && (reference = this.myImportElement.getImportReferenceExpression()) != null) {
                moduleName = PyPsiUtils.toPath(reference);
            }
            String string = PyPsiBundle.message("INTN.convert.to.from.import", this.getDots() + moduleName, "...");
            if (string == null) {
                IntentionState.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private String getDots() {
            Object dots = "";
            for (int i = 0; i < this.myRelativeLevel; ++i) {
                dots = (String)dots + ".";
            }
            String string = dots;
            if (string == null) {
                IntentionState.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

