/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.Gray;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayOutput;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.MouseWheelUtils;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayProgressStatus;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.NotebookInlayMultiOutput;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.NotebookInlayOutput;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.NotebookInlayState;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ToolBarProvider;
import org.jetbrains.plugins.notebooks.visualization.r.ui.ToolbarUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\b\u0002\u0010!\u001a\u00020\fH\u0002J\b\u0010\"\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0&0&2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020\u00112\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&H\u0016J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020*J\u0010\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u000eH\u0002J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u000205H\u0016J\u0014\u0010\u001e\u001a\u00020\u0011*\u0002062\u0006\u00107\u001a\u00020-H\u0002J\u0014\u0010.\u001a\u00020\u0011*\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u00108\u001a\u00020\u0011*\u000206H\u0002R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/TabbedMultiOutput;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/NotebookInlayMultiOutput;", "editor", "Lcom/intellij/openapi/editor/Editor;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/Disposable;)V", "disposable", "Lorg/jetbrains/annotations/NotNull;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "isInViewport", "", "maxHeight", "", "onChange", "Lkotlin/Function0;", "", "getOnChange", "()Lkotlin/jvm/functions/Function0;", "setOnChange", "(Lkotlin/jvm/functions/Function0;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "tabsOutput", "", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/NotebookInlayOutput;", "addTab", "Lcom/intellij/ui/tabs/TabInfo;", "tabInfo", "select", "clear", "createClearAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "createTabActionGroups", "", "createTabToolbar", "Ljavax/swing/JComponent;", "getCollapsedDescription", "", "onOutputs", "inlayOutputs", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayOutput;", "onViewportChange", "setCurrentPage", "currentPage", "updateMaxHeight", "height", "updateProgressStatus", "progressStatus", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayProgressStatus;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/NotebookInlayState;", "inlayOutput", "setupOnHeightCalculated", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nTabbedMultiOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabbedMultiOutput.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/TabbedMultiOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1855#3,2:188\n1855#3,2:190\n*S KotlinDebug\n*F\n+ 1 TabbedMultiOutput.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/TabbedMultiOutput\n*L\n83#1:188,2\n94#1:190,2\n*E\n"})
public final class TabbedMultiOutput
extends NotebookInlayMultiOutput {
    @NotNull
    private final Editor editor;
    @NotNull
    private final JBTabsImpl tabs;
    @Nullable
    private Function0<Unit> onChange;
    @NotNull
    private final Disposable disposable;
    private int maxHeight;
    @NotNull
    private final Project project;
    @NotNull
    private final Set<NotebookInlayOutput> tabsOutput;
    private volatile boolean isInViewport;

    public TabbedMultiOutput(@NotNull Editor editor, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.editor = editor;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        this.disposable = disposable;
        this.maxHeight = -1;
        Project project = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        this.project = project;
        this.tabsOutput = new LinkedHashSet();
        Disposer.register((Disposable)parent, (Disposable)this.disposable);
        this.tabs = new JBTabsImpl(this.project, this.disposable);
        this.tabs.addListener(new TabsListener(){

            public void selectionChanged(@Nullable TabInfo oldSelection, @Nullable TabInfo newSelection) {
                block2: {
                    if (oldSelection != null) {
                        this.onViewportChange(oldSelection, false);
                    }
                    if (newSelection != null) {
                        this.onViewportChange(newSelection, isInViewport);
                    }
                    Function0<Unit> function0 = this.getOnChange();
                    if (function0 == null) break block2;
                    function0.invoke();
                }
            }
        });
        this.tabs.getComponent().setOpaque(false);
        this.tabs.getComponent().setBackground(Gray.TRANSPARENT);
        MouseWheelUtils.INSTANCE.wrapMouseWheelListeners(this.tabs.getComponent(), parent);
        this.add((Component)this.tabs.getComponent(), "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                tabs.getComponent().setBounds(new Rectangle(0, 0, e.getComponent().getBounds().width, e.getComponent().getBounds().height));
            }
        });
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public final Function0<Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@Nullable Function0<Unit> function0) {
        this.onChange = function0;
    }

    public final void setCurrentPage(@NotNull String currentPage) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)currentPage, (String)"currentPage");
            Iterable iterable = this.tabs.getTabs();
            for (Object t : iterable) {
                TabInfo it = (TabInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)currentPage)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TabInfo tabToSelect = v0;
        if (tabToSelect != null) {
            this.tabs.select(tabToSelect, false);
        }
    }

    @Override
    public void onOutputs(@NotNull List<InlayOutput> inlayOutputs) {
        Intrinsics.checkNotNullParameter(inlayOutputs, (String)"inlayOutputs");
        this.tabs.removeAllTabs();
        this.tabsOutput.clear();
        Iterable $this$forEach$iv = inlayOutputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookInlayOutput notebookInlayOutput;
            InlayOutput inlayOutput = (InlayOutput)element$iv;
            boolean bl = false;
            NotebookInlayOutput $this$onOutputs_u24lambda_u242_u24lambda_u241 = notebookInlayOutput = new NotebookInlayOutput(this.editor, this.disposable);
            boolean bl2 = false;
            this.setupOnHeightCalculated($this$onOutputs_u24lambda_u242_u24lambda_u241);
            $this$onOutputs_u24lambda_u242_u24lambda_u241.addData(inlayOutput.getType(), inlayOutput.getData(), inlayOutput.getProgressStatus());
            this.tabsOutput.add($this$onOutputs_u24lambda_u242_u24lambda_u241);
            this.addTab($this$onOutputs_u24lambda_u242_u24lambda_u241, inlayOutput);
        }
    }

    @Override
    public void updateProgressStatus(@NotNull InlayProgressStatus progressStatus) {
        Intrinsics.checkNotNullParameter((Object)progressStatus, (String)"progressStatus");
        Iterable $this$forEach$iv = this.tabsOutput;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookInlayOutput output = (NotebookInlayOutput)element$iv;
            boolean bl = false;
            output.updateProgressStatus(progressStatus);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    @NotNull
    public String getCollapsedDescription() {
        return "foooo";
    }

    @Override
    public void onViewportChange(boolean isInViewport) {
        block0: {
            this.isInViewport = isInViewport;
            TabInfo tabInfo = this.tabs.getSelectedInfo();
            if (tabInfo == null) break block0;
            this.onViewportChange(tabInfo, isInViewport);
        }
    }

    private final void onViewportChange(TabInfo $this$onViewportChange, boolean isInViewport) {
        block0: {
            NotebookInlayState notebookInlayState = (NotebookInlayState)$this$onViewportChange.getComponent();
            if (notebookInlayState == null) break block0;
            notebookInlayState.onViewportChange(isInViewport);
        }
    }

    private final void setupOnHeightCalculated(NotebookInlayState $this$setupOnHeightCalculated) {
        $this$setupOnHeightCalculated.setOnHeightCalculated((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, $this$setupOnHeightCalculated){
            final /* synthetic */ TabbedMultiOutput this$0;
            final /* synthetic */ NotebookInlayState $this_setupOnHeightCalculated;
            {
                this.this$0 = $receiver;
                this.$this_setupOnHeightCalculated = $receiver2;
                super(1);
            }

            public final void invoke(int it) {
                block0: {
                    TabInfo tabInfo = TabbedMultiOutput.access$getTabs$p(this.this$0).findInfo((Component)this.$this_setupOnHeightCalculated);
                    if (tabInfo == null) break block0;
                    TabInfo tabInfo2 = tabInfo;
                    TabbedMultiOutput tabbedMultiOutput = this.this$0;
                    TabInfo tab = tabInfo2;
                    boolean bl = false;
                    TabbedMultiOutput.access$updateMaxHeight(tabbedMultiOutput, it + TabbedMultiOutput.access$getTabs$p((TabbedMultiOutput)tabbedMultiOutput).getTabLabel((TabInfo)tab).getPreferredSize().height);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void addTab(NotebookInlayState $this$addTab, InlayOutput inlayOutput) {
        void $this$addTab_u24lambda_u246;
        Object it;
        TabInfo tabInfo;
        TabInfo tabInfo2 = tabInfo = new TabInfo((JComponent)$this$addTab);
        TabbedMultiOutput tabbedMultiOutput = this;
        boolean bl = false;
        Icon icon = inlayOutput.getPreview();
        if (icon != null) {
            it = icon;
            boolean bl2 = false;
            $this$addTab_u24lambda_u246.setIcon((Icon)it);
            $this$addTab_u24lambda_u246.setText("");
        }
        String string = inlayOutput.getTitle();
        if (string != null) {
            it = string;
            boolean bl3 = false;
            $this$addTab_u24lambda_u246.setText(inlayOutput.getTitle());
        }
        TabInfo $this$addTab_u24lambda_u248 = tabInfo = TabbedMultiOutput.addTab$default(tabbedMultiOutput, tabInfo, false, 2, null);
        boolean bl4 = false;
        TabLabel tabLabel = (TabLabel)this.tabs.getInfoToLabel().get($this$addTab_u24lambda_u248);
        if (tabLabel != null) {
            TabLabel tabLabel2;
            TabLabel $this$addTab_u24lambda_u248_u24lambda_u247 = tabLabel2 = tabLabel;
            boolean bl5 = false;
            if (inlayOutput.getPreferredWidth() != 0) {
                $this$addTab_u24lambda_u248_u24lambda_u247.setPreferredSize(new Dimension(inlayOutput.getPreferredWidth(), 0));
            }
        }
        if (this.tabs.getSelectedInfo() == null) {
            this.tabs.select($this$addTab_u24lambda_u248, false);
        }
    }

    private final TabInfo addTab(TabInfo tabInfo, boolean select) {
        tabInfo.setActions((ActionGroup)new DefaultActionGroup(), "unknown");
        tabInfo.setSideComponent(this.createTabToolbar(tabInfo));
        this.tabs.addTab(tabInfo);
        if (select) {
            this.tabs.select(tabInfo, false);
        }
        return tabInfo;
    }

    static /* synthetic */ TabInfo addTab$default(TabbedMultiOutput tabbedMultiOutput, TabInfo tabInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return tabbedMultiOutput.addTab(tabInfo, bl);
    }

    private final JComponent createTabToolbar(TabInfo tabInfo) {
        JPanel jPanel;
        List<List<AnAction>> actionGroups = this.createTabActionGroups(tabInfo);
        JComponent toolbar = ToolbarUtil.INSTANCE.createActionToolbar(actionGroups);
        if (toolbar instanceof ActionToolbarImpl) {
            ((ActionToolbarImpl)toolbar).setForceMinimumSize(true);
        }
        JPanel $this$createTabToolbar_u24lambda_u249 = jPanel = new JPanel();
        boolean bl = false;
        $this$createTabToolbar_u24lambda_u249.add(toolbar);
        return jPanel;
    }

    private final List<List<AnAction>> createTabActionGroups(TabInfo tabInfo) {
        List list;
        List groups = list = (List)new ArrayList();
        boolean bl = false;
        JComponent jComponent = tabInfo.getComponent();
        ToolBarProvider toolBarProvider = jComponent instanceof ToolBarProvider ? (ToolBarProvider)((Object)jComponent) : null;
        if (toolBarProvider != null) {
            ToolBarProvider provider2 = toolBarProvider;
            boolean bl2 = false;
            groups.add(provider2.createActions());
        }
        groups.add(CollectionsKt.listOf((Object)this.createClearAction()));
        return list;
    }

    private final AnAction createClearAction() {
        return (AnAction)ToolbarUtil.INSTANCE.createAnActionButton("org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ClearOutputAction", (Function0<Unit>)((Function0)new Function0<Unit>(this.getClearAction()){

            public final void invoke() {
                ((Function0)this.receiver).invoke();
            }
        }));
    }

    private final void updateMaxHeight(int height) {
        block1: {
            if (this.maxHeight >= height) break block1;
            this.maxHeight = height;
            Function1<Integer, Unit> function1 = this.getOnHeightCalculated();
            if (function1 != null) {
                function1.invoke((Object)this.maxHeight);
            }
        }
    }

    public static final /* synthetic */ void access$updateMaxHeight(TabbedMultiOutput $this, int height) {
        $this.updateMaxHeight(height);
    }
}

