/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayDimensions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u0004J\u001e\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u00104\u001a\u00020:J\u000e\u0010;\u001a\u00020\u00042\u0006\u00104\u001a\u000205J\u000e\u0010<\u001a\u00020=2\u0006\u00104\u001a\u00020>R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u001b\u0010\u0019\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0006R\u001b\u0010\u001d\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u0006R\u001e\u0010 \u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0006R\u001e\u0010\"\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0006R\u0011\u0010*\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0006R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u00100\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0006\u00a8\u0006?"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayDimensions;", "", "()V", "bottomBorder", "", "getBottomBorder", "()I", "bottomBorderUnscaled", "bottomOffset", "getBottomOffset", "bottomOffsetUnscaled", "cornerRadius", "getCornerRadius", "<set-?>", "defaultHeight", "getDefaultHeight", "initialized", "", "leftBorderUnscaled", "lineHeight", "getLineHeight", "minHeight", "getMinHeight", "minWidth", "getMinWidth", "multiOutputDefaultHeight", "getMultiOutputDefaultHeight", "multiOutputDefaultHeight$delegate", "Lkotlin/Lazy;", "multiOutputHeightThreshold", "getMultiOutputHeightThreshold", "multiOutputHeightThreshold$delegate", "previewHeight", "getPreviewHeight", "rightBorder", "getRightBorder", "rightBorderUnscaled", "smallHeight", "getSmallHeight", "spaceWidth", "tableHeight", "getTableHeight", "topBorder", "getTopBorder", "topBorderUnscaled", "topOffset", "getTopOffset", "topOffsetUnscaled", "width", "getWidth", "calculateInlayContentSize", "Ljava/awt/Dimension;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "inlayHeight", "calculateInlayHeight", "maxWidth", "maxHeight", "Lcom/intellij/openapi/editor/Editor;", "calculateInlayWidth", "init", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nInlayDimensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayDimensions.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayDimensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class InlayDimensions {
    @NotNull
    public static final InlayDimensions INSTANCE = new InlayDimensions();
    private static final int topOffsetUnscaled = 10;
    private static final int bottomOffsetUnscaled = 24;
    private static final int topOffset = JBUI.scale((int)10);
    private static final int bottomOffset = JBUI.scale((int)24);
    public static final int topBorderUnscaled = 13;
    public static final int bottomBorderUnscaled = 29;
    public static final int leftBorderUnscaled = 0;
    public static final int rightBorderUnscaled = 0;
    @NotNull
    private static final Lazy multiOutputHeightThreshold$delegate = LazyKt.lazy((Function0)multiOutputHeightThreshold.2.INSTANCE);
    @NotNull
    private static final Lazy multiOutputDefaultHeight$delegate = LazyKt.lazy((Function0)multiOutputDefaultHeight.2.INSTANCE);
    private static final int topBorder = JBUI.scale((int)13);
    private static final int bottomBorder = JBUI.scale((int)29);
    private static final int cornerRadius = JBUI.scale((int)10);
    private static volatile int lineHeight = JBUI.scale((int)10);
    private static volatile int rightBorder = 5;
    private static int spaceWidth = JBUI.scale((int)5);
    private static volatile int smallHeight = lineHeight;
    private static volatile int previewHeight = lineHeight;
    private static volatile int defaultHeight = lineHeight;
    private static volatile int tableHeight = lineHeight;
    private static volatile int width = spaceWidth * 120;
    private static volatile int minWidth = spaceWidth * 10;
    private static volatile int minHeight = spaceWidth * 10;
    private static boolean initialized;

    private InlayDimensions() {
    }

    public final int getTopOffset() {
        return topOffset;
    }

    public final int getBottomOffset() {
        return bottomOffset;
    }

    public final int getMultiOutputHeightThreshold() {
        Lazy lazy = multiOutputHeightThreshold$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getMultiOutputDefaultHeight() {
        Lazy lazy = multiOutputDefaultHeight$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getTopBorder() {
        return topBorder;
    }

    public final int getBottomBorder() {
        return bottomBorder;
    }

    public final int getCornerRadius() {
        return cornerRadius;
    }

    public final int getLineHeight() {
        return lineHeight;
    }

    public final int getRightBorder() {
        return rightBorder;
    }

    public final int getSmallHeight() {
        return smallHeight;
    }

    public final int getPreviewHeight() {
        return previewHeight;
    }

    public final int getDefaultHeight() {
        return defaultHeight;
    }

    public final int getTableHeight() {
        return tableHeight;
    }

    public final int getWidth() {
        return width;
    }

    public final int getMinWidth() {
        return minWidth;
    }

    public final int getMinHeight() {
        return minHeight;
    }

    public final void init(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (initialized) {
            return;
        }
        lineHeight = editor.getLineHeight() + JBUI.scale((int)5);
        spaceWidth = editor.getFontMetrics(0).charWidth(' ');
        smallHeight = lineHeight + topBorder + bottomBorder;
        defaultHeight = lineHeight * 25 + topBorder + bottomBorder;
        tableHeight = lineHeight * 25 + topBorder + bottomBorder;
        previewHeight = lineHeight * 4 + topBorder + bottomBorder;
        width = spaceWidth * 120;
        minWidth = spaceWidth * 10;
        minHeight = smallHeight;
        rightBorder = spaceWidth * 3;
    }

    public final int calculateInlayWidth(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int n = 0;
        JScrollPane it = editor.getScrollPane();
        boolean bl = false;
        int n2 = it.getViewport().getWidth() - it.getVerticalScrollBar().getWidth();
        return Math.max(n, n2);
    }

    public final int calculateInlayHeight(int maxWidth, int maxHeight, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int scaleMultiplier = UIUtil.isRetina() ? 2 : 1;
        int editorWidth = editor.getContentComponent().getWidth();
        return maxWidth * scaleMultiplier <= editorWidth ? maxHeight * scaleMultiplier : maxHeight * editorWidth / maxWidth;
    }

    @NotNull
    public final Dimension calculateInlayContentSize(@NotNull EditorEx editor, int inlayHeight) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int inlayWidth = this.calculateInlayWidth(editor);
        int contentWidth = Math.max(inlayWidth - JBUI.scale((int)0) - JBUI.scale((int)0), 0);
        int contentHeight = Math.max(inlayHeight - topBorder - topOffset - bottomBorder - bottomOffset, 0);
        return new Dimension(contentWidth, contentHeight);
    }

    public static /* synthetic */ Dimension calculateInlayContentSize$default(InlayDimensions inlayDimensions, EditorEx editorEx, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = defaultHeight;
        }
        return inlayDimensions.calculateInlayContentSize(editorEx, n);
    }
}

