/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.refactoring.InplaceRefactoringContinuation;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/commands/StartInlineRenameCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nStartInlineRenameCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartInlineRenameCommand.kt\ncom/jetbrains/performancePlugin/commands/StartInlineRenameCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,70:1\n1360#2:71\n1446#2,5:72\n21#3,3:77\n101#3,2:80\n116#3:82\n104#3,10:83\n*S KotlinDebug\n*F\n+ 1 StartInlineRenameCommand.kt\ncom/jetbrains/performancePlugin/commands/StartInlineRenameCommand\n*L\n52#1:71\n52#1:72,5\n59#1:77,3\n59#1:80,2\n59#1:82\n59#1:83,10\n*E\n"})
public final class StartInlineRenameCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SPAN_NAME = "startInlineRename";
    @NotNull
    public static final String PREFIX = "%startInlineRename";

    public StartInlineRenameCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RefactoringSettings.getInstance().RENAME_SHOW_AUTOMATIC_RENAMING_DIALOG = false;
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> StartInlineRenameCommand._execute$lambda$2(actionCallback, project2)));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void _execute$lambda$2(ActionCallbackProfilerStopper $actionCallback, Project $project) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$actionCallback), (String)"$actionCallback");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Component focusedComponent = IdeFocusManager.findInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusedComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getInstance().getDataContext(focusedComponent)");
        DataContext dataContext2 = dataContext;
        Editor editor = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            $actionCallback.reject("Editor is not focused");
            return;
        }
        if (InplaceRefactoringContinuation.tryResumeInplaceContinuation((Project)$project, (Editor)editor, RenameElementAction.class)) {
            $actionCallback.reject("Another refactoring is in progress");
            return;
        }
        if (!PsiDocumentManager.getInstance((Project)$project).commitAllDocumentsUnderProgress()) {
            $actionCallback.reject("Can't commit documents");
            return;
        }
        Iterable $this$flatMap$iv = RenamerFactory.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RenamerFactory factory = (RenamerFactory)element$iv$iv;
            boolean bl = false;
            Collection collection = factory.createRenamers(dataContext2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"factory.createRenamers(dataContext)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List renamers = (List)destination$iv$iv;
        if (renamers.isEmpty()) {
            $actionCallback.reject("Renamers are empty");
        } else {
            if (renamers.size() == 1) {
                SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"TRACER.spanBuilder(SPAN_NAME)");
                SpanBuilder $this$useWithScope$iv = spanBuilder;
                boolean $i$f$useWithScope = false;
                Span span$iv = $this$useWithScope$iv.startSpan();
                AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    Unit unit;
                    Scope it$iv = (Scope)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)span$iv, (String)"span");
                    Span $this$use$iv$iv = span$iv;
                    boolean $i$f$use = false;
                    try {
                        Span it = $this$use$iv$iv;
                        boolean bl2 = false;
                        ((Renamer)renamers.get(0)).performRename();
                        $actionCallback.setDone();
                        unit = Unit.INSTANCE;
                    }
                    catch (CancellationException e$iv$iv) {
                        throw e$iv$iv;
                    }
                    catch (ProcessCanceledException e$iv$iv) {
                        throw e$iv$iv;
                    }
                    catch (Throwable e$iv$iv) {
                        $this$use$iv$iv.recordException(e$iv$iv);
                        $this$use$iv$iv.setStatus(StatusCode.ERROR);
                        throw e$iv$iv;
                    }
                    finally {
                        $this$use$iv$iv.end();
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            $actionCallback.reject("There are too many renamers");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/performancePlugin/commands/StartInlineRenameCommand$Companion;", "", "()V", "PREFIX", "", "SPAN_NAME", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

