/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.StringHash;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.coverage.gnu.trove.TLongObjectHashMap;

public class StringsPool {
    private static final TLongObjectHashMap<String> myReusableStrings;
    private static final Map<Long, String> myConcurrentReusableStrings;
    private static final String EMPTY = "";

    public static String getFromPool(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return EMPTY;
        }
        long hash = StringHash.calc(value);
        String reused = StringsPool.getReusable(hash);
        if (reused != null) {
            return reused;
        }
        reused = new String(value);
        StringsPool.putReusable(hash, reused);
        return reused;
    }

    private static String getReusable(long hash) {
        if (myConcurrentReusableStrings != null) {
            return myConcurrentReusableStrings.get(hash);
        }
        return myReusableStrings.get(hash);
    }

    private static void putReusable(long hash, String value) {
        if (myConcurrentReusableStrings != null) {
            myConcurrentReusableStrings.put(hash, value);
        } else {
            myReusableStrings.put(hash, value);
        }
    }

    static {
        int initialCapacity = 30000;
        if (OptionsUtil.THREAD_SAFE_STORAGE) {
            myConcurrentReusableStrings = new ConcurrentHashMap<Long, String>(initialCapacity);
            myReusableStrings = null;
        } else {
            myReusableStrings = new TLongObjectHashMap(initialCapacity);
            myConcurrentReusableStrings = null;
        }
    }
}

