/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.util.LinesUtil;
import com.intellij.rt.coverage.instrumentation.util.LocalVariableInserter;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class LineInstrumenter
extends Instrumenter {
    private final CoverageDataAccess myDataAccess;
    private int myLastId = 0;

    public LineInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldSaveSource, CoverageDataAccess dataAccess) {
        super(projectData, classVisitor, className, shouldSaveSource);
        this.myDataAccess = dataAccess;
    }

    public MethodVisitor createMethodLineEnumerator(MethodVisitor mv, final String name, final String desc, int access, String signature, String[] exceptions) {
        mv = new LocalVariableInserter(mv, access, desc, "__$localHits$__", "[I"){

            public void visitLineNumber(int line, Label start) {
                LineData lineData = LineInstrumenter.this.getOrCreateLineData(line, name, desc);
                if (lineData != null) {
                    if (lineData.getId() == -1) {
                        lineData.setId(LineInstrumenter.this.myLastId++);
                    }
                    InstrumentationUtils.touchById(this.mv, this.getLVIndex(), lineData.getId());
                }
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                LineInstrumenter.this.myDataAccess.onMethodStart(this.mv, this.getLVIndex());
                super.visitCode();
            }
        };
        return this.myDataAccess.createMethodVisitor(mv, name, true);
    }

    public void visitEnd() {
        this.myDataAccess.onClassEnd(this);
        super.visitEnd();
    }

    protected void initLineData() {
        this.myClassData.setLines(LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines));
        this.myClassData.createHitsMask(this.myLastId);
    }
}

