/*
 * Decompiled with CFR 0.152.
 */
package externalApp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalAppUtil {
    @NotNull
    public static Result sendIdeRequest(@NotNull String entryPoint, int idePort, @NotNull String handlerId, @Nullable String bodyContent) {
        Result result;
        HttpResponse<String> response;
        block9: {
            if (entryPoint == null) {
                ExternalAppUtil.$$$reportNull$$$0(0);
            }
            if (handlerId == null) {
                ExternalAppUtil.$$$reportNull$$$0(1);
            }
            TrustManager[] tm = new TrustManager[]{new AllowingTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tm, null);
            HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).sslContext(sslContext).connectTimeout(Duration.ofSeconds(5L)).build();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(String.format("https://127.0.0.1:%s/api/%s?%s=%s", idePort, entryPoint, "handlerId", handlerId)));
            if (bodyContent != null) {
                requestBuilder.POST(HttpRequest.BodyPublishers.ofString(bodyContent));
            } else {
                requestBuilder.POST(HttpRequest.BodyPublishers.noBody());
            }
            response = client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) break block9;
            Result result2 = Result.success(response.body());
            if (result2 == null) {
                ExternalAppUtil.$$$reportNull$$$0(2);
            }
            return result2;
        }
        try {
            result = Result.error(response.body());
        }
        catch (IOException | InterruptedException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            ExternalAppUtil.$$$reportNull$$$0(3);
        }
        return result;
    }

    @NotNull
    public static String getEnv(@NotNull String env) {
        String value;
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(4);
        }
        if ((value = System.getenv(env)) == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        String string = value;
        if (string == null) {
            ExternalAppUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static int getEnvInt(@NotNull String env) {
        if (env == null) {
            ExternalAppUtil.$$$reportNull$$$0(6);
        }
        return Integer.parseInt(ExternalAppUtil.getEnv(env));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerId";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalApp/ExternalAppUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "externalApp/ExternalAppUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sendIdeRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sendIdeRequest";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEnv";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEnvInt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    private static class AllowingTrustManager
    extends X509ExtendedTrustManager {
        private AllowingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }

    public static class Result {
        public final boolean isError;
        public final String response;
        public final String error;

        private Result(String response, String error, boolean isError) {
            this.response = response;
            this.error = error;
            this.isError = isError;
        }

        public static Result success(@Nullable String response) {
            return new Result(response, null, false);
        }

        public static Result error(@Nullable String error) {
            return new Result(null, error != null ? error : "No response", true);
        }
    }
}

