/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.DotGraphVisitor;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.TracedRegionVisitor;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxException;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DebugUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DebugUtils.class);

    private DebugUtils() {
    }

    public static void dump(MethodNode mth) {
        DebugUtils.dump(mth, "dump");
    }

    public static void dumpRaw(MethodNode mth, String desc) {
        File out = new File("test-graph-" + desc + "-tmp");
        DotGraphVisitor.dumpRaw().save(out, mth);
    }

    public static IDexTreeVisitor dumpRawVisitor(final String desc) {
        return new AbstractVisitor(){

            @Override
            public void visit(MethodNode mth) throws JadxException {
                DebugUtils.dumpRaw(mth, desc);
            }
        };
    }

    public static void dump(MethodNode mth, String desc) {
        File out = new File("test-graph-" + desc + "-tmp");
        DotGraphVisitor.dump().save(out, mth);
        DotGraphVisitor.dumpRaw().save(out, mth);
        DotGraphVisitor.dumpRegions().save(out, mth);
    }

    public static void printRegionsWithBlock(MethodNode mth, final BlockNode block) {
        final LinkedHashSet regions = new LinkedHashSet();
        DepthRegionTraversal.traverse(mth, new TracedRegionVisitor(){

            @Override
            public void processBlockTraced(MethodNode mth, IBlock container, IRegion currentRegion) {
                if (block.equals(container)) {
                    regions.add(currentRegion);
                }
            }
        });
        LOG.debug(" Found block: {} in regions: {}", (Object)block, regions);
    }

    public static IDexTreeVisitor printRegionsVisitor() {
        return new AbstractVisitor(){

            @Override
            public void visit(MethodNode mth) throws JadxException {
                DebugUtils.printRegions(mth, true);
            }
        };
    }

    public static void printRegions(MethodNode mth) {
        DebugUtils.printRegions(mth, false);
    }

    public static void printRegion(MethodNode mth, IRegion region, boolean printInsn) {
        DebugUtils.printRegion(mth, region, "", printInsn);
    }

    public static void printRegions(MethodNode mth, boolean printInsns) {
        LOG.debug("|{}", (Object)mth);
        DebugUtils.printRegion(mth, mth.getRegion(), "|  ", printInsns);
    }

    private static void printRegion(MethodNode mth, IRegion region, String indent, boolean printInsns) {
        LOG.debug("{}{} {}", new Object[]{indent, region, region.getAttributesString()});
        indent = indent + "|  ";
        for (IContainer container : region.getSubBlocks()) {
            if (container instanceof IRegion) {
                DebugUtils.printRegion(mth, (IRegion)container, indent, printInsns);
                continue;
            }
            LOG.debug("{}{} {}", new Object[]{indent, container, container.getAttributesString()});
            if (!printInsns || !(container instanceof IBlock)) continue;
            IBlock block = (IBlock)container;
            DebugUtils.printInsns(mth, indent, block);
        }
    }

    private static void printInsns(MethodNode mth, String indent, IBlock block) {
        for (InsnNode insn : block.getInstructions()) {
            try {
                MethodGen mg = MethodGen.getFallbackMethodGen(mth);
                InsnGen ig = new InsnGen(mg, true);
                CodeWriter code = new CodeWriter();
                ig.makeInsn(insn, code);
                String insnStr = code.toString().substring(CodeWriter.NL.length());
                String attrStr = insn.isAttrStorageEmpty() ? "" : '\t' + insn.getAttributesString();
                LOG.debug("{}|> {}{}", new Object[]{indent, insnStr, attrStr});
            }
            catch (CodegenException e) {
                LOG.debug("{}|>!! {}", (Object)indent, (Object)insn);
            }
        }
    }

    public static void printMap(String desc, Map<?, ?> map) {
        LOG.debug("Map of {}, size: {}", (Object)desc, (Object)map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            LOG.debug("  {} : {}", entry.getKey(), entry.getValue());
        }
    }
}

