/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Destroys;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.file.Deleter;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Deletion cannot be cached")
public abstract class Delete
extends ConventionTask
implements DeleteSpec {
    private ConfigurableFileCollection paths = this.getProject().getObjects().fileCollection();
    private boolean followSymlinks;

    @TaskAction
    protected void clean() throws IOException {
        boolean didWork = false;
        for (File path : this.paths) {
            didWork |= this.getDeleter().deleteRecursively(path, this.followSymlinks);
        }
        this.setDidWork(didWork);
    }

    @Destroys
    public FileCollection getTargetFiles() {
        return this.paths;
    }

    @Internal
    public Set<Object> getDelete() {
        return this.paths.getFrom();
    }

    public void setDelete(Set<Object> targets) {
        this.paths.setFrom(targets);
    }

    public void setDelete(Object target) {
        this.paths.setFrom(new Object[]{target});
    }

    @Input
    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public Delete delete(Object ... targets) {
        this.paths.from(targets);
        return this;
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator injects implementation");
    }
}

