/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.impl.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.impl.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirTypeParameterRefComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "Lkotlin/Comparator;", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;)I", "compare", "a", "b", "tree"})
public final class FirTypeParameterRefComparator
implements Comparator<FirTypeParameterRef> {
    @NotNull
    public static final FirTypeParameterRefComparator INSTANCE = new FirTypeParameterRefComparator();

    private FirTypeParameterRefComparator() {
    }

    private final int getPriority(FirTypeParameterRef $this$priority) {
        FirTypeParameterRef firTypeParameterRef = $this$priority;
        return firTypeParameterRef instanceof FirConstructedClassTypeParameterRef ? 3 : (firTypeParameterRef instanceof FirOuterClassTypeParameterRef ? 2 : (firTypeParameterRef instanceof FirTypeParameter ? 1 : 0));
    }

    @Override
    public int compare(@NotNull FirTypeParameterRef a, @NotNull FirTypeParameterRef b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int priorityDiff = this.getPriority(a) - this.getPriority(b);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        FirTypeParameterRef firTypeParameterRef = a;
        if (firTypeParameterRef instanceof FirConstructedClassTypeParameterRef) {
            if (!(b instanceof FirConstructedClassTypeParameterRef)) {
                boolean $i$a$-require-FirTypeParameterRefComparator$compare$42 = false;
                String $i$a$-require-FirTypeParameterRefComparator$compare$42 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException($i$a$-require-FirTypeParameterRefComparator$compare$42.toString());
            }
            return a.getSymbol().getName().compareTo(b.getSymbol().getName());
        }
        if (firTypeParameterRef instanceof FirOuterClassTypeParameterRef) {
            if (!(b instanceof FirOuterClassTypeParameterRef)) {
                boolean $i$a$-require-FirTypeParameterRefComparator$compare$52 = false;
                String $i$a$-require-FirTypeParameterRefComparator$compare$52 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException($i$a$-require-FirTypeParameterRefComparator$compare$52.toString());
            }
            return a.getSymbol().getName().compareTo(b.getSymbol().getName());
        }
        if (firTypeParameterRef instanceof FirTypeParameter) {
            if (!(b instanceof FirTypeParameter)) {
                boolean $i$a$-require-FirTypeParameterRefComparator$compare$62 = false;
                String $i$a$-require-FirTypeParameterRefComparator$compare$62 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException($i$a$-require-FirTypeParameterRefComparator$compare$62.toString());
            }
            int nameDiff = a.getSymbol().getName().compareTo(b.getSymbol().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            int varianceDiff = ((FirTypeParameter)a).getVariance().ordinal() - ((FirTypeParameter)b).getVariance().ordinal();
            if (varianceDiff != 0) {
                return varianceDiff;
            }
            int boundsSizeDiff = ((FirTypeParameter)a).getBounds().size() - ((FirTypeParameter)b).getBounds().size();
            if (boundsSizeDiff != 0) {
                return boundsSizeDiff;
            }
            for (Pair pair : CollectionsKt.zip((Iterable)((FirTypeParameter)a).getBounds(), (Iterable)((FirTypeParameter)b).getBounds())) {
                FirTypeRef bBound;
                FirTypeRef aBound = (FirTypeRef)pair.component1();
                int boundDiff = FirTypeRefComparator.INSTANCE.compare(aBound, bBound = (FirTypeRef)pair.component2());
                if (boundDiff == 0) continue;
                return boundDiff;
            }
            return 0;
        }
        throw new IllegalStateException(("Unsupported type parameter reference comparison: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b)).toString());
    }
}

