/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Labels;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtils;

public class LabelExpression {
    private HashSet<String> labels = new LinkedHashSet<String>();
    private String originalString = null;

    public LabelExpression() {
    }

    public LabelExpression(String ... labels) {
        if (labels.length == 1) {
            this.parseLabelString(labels[0]);
        } else {
            for (String label : labels) {
                this.parseLabelString(label.toLowerCase());
            }
        }
    }

    public LabelExpression(String labels) {
        if (labels != null) {
            labels = labels.replace("\\", "");
        }
        this.parseLabelString(labels);
        this.originalString = labels;
    }

    public LabelExpression(Collection<String> labels) {
        if (labels != null) {
            for (String label : labels) {
                this.labels.add(label.toLowerCase());
            }
        }
    }

    private void parseLabelString(String labels) {
        if ((labels = StringUtils.trimToNull(labels)) == null) {
            return;
        }
        for (String label : StringUtils.splitAndTrim(labels, ",")) {
            this.labels.add(label.toLowerCase());
        }
    }

    public boolean add(String label) {
        return this.labels.add(label.toLowerCase());
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    public String toString() {
        if (this.originalString != null) {
            return this.originalString;
        }
        return "(" + StringUtils.join(new TreeSet<String>(this.labels), "), (") + ")";
    }

    public boolean matches(Labels runtimeLabels) {
        if (runtimeLabels == null || runtimeLabels.isEmpty()) {
            return true;
        }
        if (this.labels.size() == 0) {
            return true;
        }
        for (String expression : this.labels) {
            if (!this.matches(expression, runtimeLabels)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String expression, Labels runtimeLabels) {
        if (runtimeLabels.isEmpty()) {
            return true;
        }
        if (expression.trim().equals(":TRUE")) {
            return true;
        }
        if (expression.trim().equals(":FALSE")) {
            return false;
        }
        while (expression.contains("(")) {
            Pattern pattern = Pattern.compile("(.*?)\\(([^\\(\\)]*?)\\)(.*)");
            Matcher matcher = pattern.matcher(expression);
            if (!matcher.matches()) {
                throw new UnexpectedLiquibaseException("Cannot parse label pattern " + expression);
            }
            String parenExpression = matcher.group(2);
            parenExpression = ":" + String.valueOf(this.matches(parenExpression, runtimeLabels)).toUpperCase();
            expression = matcher.group(1) + " " + parenExpression + " " + matcher.group(3);
        }
        String[] orSplit = expression.split("\\s+or\\s+");
        if (orSplit.length > 1) {
            for (String split : orSplit) {
                if (!this.matches(split, runtimeLabels)) continue;
                return true;
            }
            return false;
        }
        String[] andSplit = expression.split("\\s+and\\s+");
        if (andSplit.length > 1) {
            for (String split : andSplit) {
                if (this.matches(split, runtimeLabels)) continue;
                return false;
            }
            return true;
        }
        boolean notExpression = false;
        if (expression.startsWith("!")) {
            notExpression = true;
            expression = expression.substring(1);
        } else if (expression.toLowerCase().startsWith("not ")) {
            notExpression = true;
            expression = expression.substring(4);
        }
        if (expression.trim().equals(":TRUE")) {
            return !notExpression;
        }
        if (expression.trim().equals(":FALSE")) {
            return notExpression;
        }
        for (String label : runtimeLabels.getLabels()) {
            if (!label.equalsIgnoreCase(expression)) continue;
            return !notExpression;
        }
        return notExpression;
    }

    public boolean isEmpty() {
        return this.labels == null || this.labels.size() == 0;
    }
}

