/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;

public class InstrumentedHttpListenerFactory
implements SolrMetricProducer,
HttpListenerFactory {
    private static final NameStrategy QUERYLESS_URL_AND_METHOD = (scope, request) -> {
        String schemeHostPort = request.getScheme() + "://" + request.getHost() + ":" + request.getPort() + request.getPath();
        return SolrMetricManager.mkName(schemeHostPort + "." + InstrumentedHttpListenerFactory.methodNameString(request), scope);
    };
    private static final NameStrategy METHOD_ONLY = (scope, request) -> SolrMetricManager.mkName(InstrumentedHttpListenerFactory.methodNameString(request), scope);
    private static final NameStrategy HOST_AND_METHOD = (scope, request) -> {
        String schemeHostPort = request.getScheme() + "://" + request.getHost() + ":" + request.getPort();
        return SolrMetricManager.mkName(schemeHostPort + "." + InstrumentedHttpListenerFactory.methodNameString(request), scope);
    };
    public static final Map<String, NameStrategy> KNOWN_METRIC_NAME_STRATEGIES = new HashMap<String, NameStrategy>(3);
    protected SolrMetricsContext solrMetricsContext;
    protected String scope;
    protected NameStrategy nameStrategy;

    public InstrumentedHttpListenerFactory(NameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    private static String methodNameString(Request request) {
        return request.getMethod().toLowerCase(Locale.ROOT) + ".requests";
    }

    public HttpListenerFactory.RequestResponseListener get() {
        return new HttpListenerFactory.RequestResponseListener(){
            Timer.Context timerContext;

            public void onBegin(Request request) {
                if (InstrumentedHttpListenerFactory.this.solrMetricsContext != null) {
                    this.timerContext = InstrumentedHttpListenerFactory.this.timer(request).time();
                }
            }

            public void onComplete(Result result) {
                if (this.timerContext != null) {
                    this.timerContext.stop();
                }
            }
        };
    }

    private Timer timer(Request request) {
        return this.solrMetricsContext.timer(this.nameStrategy.getNameFor(this.scope, request), new String[0]);
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext;
        this.scope = scope;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    static {
        KNOWN_METRIC_NAME_STRATEGIES.put("queryLessURLAndMethod", QUERYLESS_URL_AND_METHOD);
        KNOWN_METRIC_NAME_STRATEGIES.put("hostAndMethod", HOST_AND_METHOD);
        KNOWN_METRIC_NAME_STRATEGIES.put("methodOnly", METHOD_ONLY);
    }

    public static interface NameStrategy {
        public String getNameFor(String var1, Request var2);
    }
}

