/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

import org.apache.solr.util.hll.NumberUtil;

final class HLLUtil {
    private static final long[] PW_MASK = new long[]{Long.MIN_VALUE, -1L, -4L, -64L, -16384L, -1073741824L, -4611686018427387904L, -4611686018427387904L, -4611686018427387904L};
    private static final double[] TWO_TO_L = new double[279];
    private static final int REG_WIDTH_INDEX_MULTIPLIER = 31;

    HLLUtil() {
    }

    public static int registerBitSize(long expectedUniqueElements) {
        return Math.max(1, (int)Math.ceil(NumberUtil.log2(NumberUtil.log2(expectedUniqueElements))));
    }

    public static double alphaMSquared(int m) {
        switch (m) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new IllegalArgumentException("'m' cannot be less than 16 (" + m + " < 16).");
            }
            case 16: {
                return 0.673 * (double)m * (double)m;
            }
            case 32: {
                return 0.697 * (double)m * (double)m;
            }
            case 64: {
                return 0.709 * (double)m * (double)m;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)m) * (double)m * (double)m;
    }

    public static long pwMaxMask(int registerSizeInBits) {
        return PW_MASK[registerSizeInBits];
    }

    public static double smallEstimatorCutoff(int m) {
        return (double)m * 5.0 / 2.0;
    }

    public static double smallEstimator(int m, int numberOfZeroes) {
        return (double)m * Math.log((double)m / (double)numberOfZeroes);
    }

    public static double largeEstimatorCutoff(int log2m, int registerSizeInBits) {
        return TWO_TO_L[31 * registerSizeInBits + log2m] / 30.0;
    }

    public static double largeEstimator(int log2m, int registerSizeInBits, double estimator) {
        double twoToL = TWO_TO_L[31 * registerSizeInBits + log2m];
        return -1.0 * twoToL * Math.log(1.0 - estimator / twoToL);
    }

    static {
        for (int regWidth = 1; regWidth <= 8; ++regWidth) {
            for (int log2m = 4; log2m <= 30; ++log2m) {
                double twoToL;
                int maxRegisterValue = (1 << regWidth) - 1;
                int pwBits = maxRegisterValue - 1;
                int totalBits = pwBits + log2m;
                HLLUtil.TWO_TO_L[31 * regWidth + log2m] = twoToL = Math.pow(2.0, totalBits);
            }
        }
    }
}

