/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.concurrent.ExecutorService;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;

public class OcmhCollectionCommandContext
implements CollectionCommandContext {
    private final OverseerCollectionMessageHandler ocmh;

    public OcmhCollectionCommandContext(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public boolean isDistributedCollectionAPI() {
        return false;
    }

    @Override
    public ShardHandler newShardHandler() {
        return this.ocmh.shardHandlerFactory.getShardHandler();
    }

    @Override
    public SolrCloudManager getSolrCloudManager() {
        return this.ocmh.cloudManager;
    }

    @Override
    public CoreContainer getCoreContainer() {
        return this.ocmh.overseer.getCoreContainer();
    }

    @Override
    public ZkStateReader getZkStateReader() {
        return this.ocmh.zkStateReader;
    }

    @Override
    public DistributedClusterStateUpdater getDistributedClusterStateUpdater() {
        return this.ocmh.overseer.getDistributedClusterStateUpdater();
    }

    @Override
    public void offerStateUpdate(byte[] data) throws KeeperException, InterruptedException {
        this.ocmh.overseer.offerStateUpdate(data);
    }

    @Override
    public SolrCloseable getCloseableToLatchOn() {
        return this.ocmh;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.ocmh.tpe;
    }

    @Override
    public String getOverseerId() {
        return this.ocmh.myId;
    }

    @Override
    public Stats getOverseerStats() {
        return this.ocmh.stats;
    }

    @Override
    public void submitIntraProcessMessage(Overseer.Message message) {
        this.ocmh.overseer.submit(message);
    }
}

