/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.base.Preconditions;
import org.apache.solr.cloud.DistributedConfigSetLockFactory;
import org.apache.solr.cloud.DistributedLock;
import org.apache.solr.cloud.ZkDistributedLockFactory;
import org.apache.solr.common.cloud.SolrZkClient;

public class ZkDistributedConfigSetLockFactory
extends ZkDistributedLockFactory
implements DistributedConfigSetLockFactory {
    public ZkDistributedConfigSetLockFactory(SolrZkClient zkClient, String rootPath) {
        super(zkClient, rootPath);
    }

    @Override
    public DistributedLock createLock(boolean isWriteLock, String configSetName) {
        Preconditions.checkArgument((configSetName != null ? 1 : 0) != 0, (Object)"configSetName can't be null");
        String lockPath = this.getLockPath(configSetName);
        return this.doCreateLock(isWriteLock, lockPath);
    }

    private String getLockPath(String configSetName) {
        return this.getPathPrefix().append(configSetName).toString();
    }
}

