/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonShapeBoundingBoxQuery;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Circle;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;

public class LatLonShape {
    private LatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        return LatLonShape.createIndexableFields(fieldName, polygon, false);
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        Field[] fields = new ShapeField.Triangle[tessellation.size()];
        for (int i = 0; i < tessellation.size(); ++i) {
            fields[i] = new ShapeField.Triangle(fieldName, tessellation.get(i));
        }
        return fields;
    }

    public static Field[] createIndexableFields(String fieldName, Line line) {
        int numPoints = line.numPoints();
        Field[] fields = new Field[numPoints - 1];
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            fields[i] = new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), GeoEncodingUtils.encodeLongitude(line.getLon(j)), GeoEncodingUtils.encodeLatitude(line.getLat(j)), GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)));
            ++i;
        }
        return fields;
    }

    public static Field[] createIndexableFields(String fieldName, double lat, double lon) {
        return new Field[]{new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat))};
    }

    public static Query newBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS && minLongitude > maxLongitude) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, 180.0), BooleanClause.Occur.MUST);
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, -180.0, maxLongitude), BooleanClause.Occur.MUST);
            return builder.build();
        }
        Rectangle rectangle = new Rectangle(minLatitude, maxLatitude, minLongitude, maxLongitude);
        return new LatLonShapeBoundingBoxQuery(field, queryRelation, rectangle);
    }

    public static Query newLineQuery(String field, ShapeField.QueryRelation queryRelation, Line ... lines) {
        return LatLonShape.newGeometryQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, ShapeField.QueryRelation queryRelation, Polygon ... polygons) {
        return LatLonShape.newGeometryQuery(field, queryRelation, polygons);
    }

    public static Query newPointQuery(String field, ShapeField.QueryRelation queryRelation, double[] ... points) {
        LatLonGeometry[] pointArray = new Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointArray[i] = new Point(points[i][0], points[i][1]);
        }
        return LatLonShape.newGeometryQuery(field, queryRelation, pointArray);
    }

    public static Query newDistanceQuery(String field, ShapeField.QueryRelation queryRelation, Circle ... circle) {
        return LatLonShape.newGeometryQuery(field, queryRelation, circle);
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... latLonGeometries) {
        if (latLonGeometries.length == 1) {
            LatLonGeometry geometry = latLonGeometries[0];
            if (geometry instanceof Rectangle) {
                Rectangle rect = (Rectangle)geometry;
                return LatLonShape.newBoxQuery(field, queryRelation, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
            }
            return new LatLonShapeQuery(field, queryRelation, latLonGeometries);
        }
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            return LatLonShape.makeContainsGeometryQuery(field, latLonGeometries);
        }
        return new LatLonShapeQuery(field, queryRelation, latLonGeometries);
    }

    private static Query makeContainsGeometryQuery(String field, LatLonGeometry ... latLonGeometries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (LatLonGeometry geometry : latLonGeometries) {
            if (geometry instanceof Rectangle) {
                Rectangle rect = (Rectangle)geometry;
                builder.add(LatLonShape.newBoxQuery(field, ShapeField.QueryRelation.CONTAINS, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon), BooleanClause.Occur.MUST);
                continue;
            }
            builder.add(new LatLonShapeQuery(field, ShapeField.QueryRelation.CONTAINS, geometry), BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery(builder.build());
    }
}

