/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file.common;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.CastUtils;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.role.MapRoleEntityFields;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.file.common.BlockContext;
import org.keycloak.models.map.storage.file.common.StringListMapContext;
import org.keycloak.models.map.storage.file.common.WritingMechanism;

public class MapEntityContext<T>
implements BlockContext<T> {
    private static final Logger LOG = Logger.getLogger(MapEntityContext.class);
    private final Map<String, EntityField<?>> nameToEntityField;
    private final Map<String, Supplier<? extends BlockContext<?>>> contextCreators;
    protected final Class<T> objectClass;
    protected final T result;
    private static final Map<Class, Map<String, EntityField<?>>> CACHE_FIELD_TO_EF = new IdentityHashMap();
    private static final Map<Class, Map<String, Supplier<? extends BlockContext<?>>>> CACHE_CLASS_TO_CC = new IdentityHashMap();
    private final boolean topContext;
    private boolean alreadyReadProperty = false;
    public static final String SCHEMA_VERSION = "schemaVersion";
    protected static final String ATTRIBUTES_NAME = MapRoleEntityFields.ATTRIBUTES.getName();

    public MapEntityContext(Class<T> clazz) {
        this(clazz, true);
    }

    public MapEntityContext(Class<T> clazz, boolean topContext) {
        this(clazz, CACHE_FIELD_TO_EF.computeIfAbsent(clazz, MapEntityContext::fieldsToEntityField), CACHE_CLASS_TO_CC.computeIfAbsent(clazz, MapEntityContext::fieldsToContextCreators), topContext);
    }

    protected MapEntityContext(Class<T> clazz, Map<String, EntityField<?>> nameToEntityField, Map<String, Supplier<? extends BlockContext<?>>> contextCreators, boolean topContext) {
        this.objectClass = clazz;
        this.result = DeepCloner.DUMB_CLONER.newInstance(clazz);
        this.nameToEntityField = nameToEntityField;
        this.contextCreators = contextCreators;
        this.topContext = topContext;
    }

    protected static <T> Map<String, Supplier<? extends BlockContext<?>>> fieldsToContextCreators(Class<T> type) {
        if (!ModelEntityUtil.entityFieldsKnown(type)) {
            return Collections.emptyMap();
        }
        return ModelEntityUtil.getEntityFields(type).map(ef -> Map.entry(ef, Optional.ofNullable(MapEntityContext.getDefaultContextCreator(ef)))).filter(me -> ((Optional)me.getValue()).isPresent()).collect(Collectors.toMap(me -> ((EntityField)me.getKey()).getNameCamelCase(), me -> (Supplier)((Optional)me.getValue()).get()));
    }

    private static <T> Supplier<? extends BlockContext<?>> getDefaultContextCreator(EntityField<? super T> ef) {
        Class collectionElementClass = ef.getCollectionElementClass();
        if (collectionElementClass != Void.class && ModelEntityUtil.entityFieldsKnown((Class)collectionElementClass)) {
            return () -> new MapEntitySequenceYamlContext(collectionElementClass);
        }
        Class mapValueClass = ef.getMapValueClass();
        if (mapValueClass != Void.class) {
            if (ModelEntityUtil.entityFieldsKnown((Class)mapValueClass)) {
                return () -> new MapEntityMappingYamlContext(mapValueClass);
            }
            if (ATTRIBUTES_NAME.equals(ef.getName())) {
                return StringListMapContext::new;
            }
        }
        return null;
    }

    public static <T> Map<String, EntityField<?>> fieldsToEntityField(Class<T> type) {
        return ModelEntityUtil.getEntityFields(type).collect(Collectors.toUnmodifiableMap(EntityField::getNameCamelCase, Function.identity()));
    }

    public static <T> boolean setEntityField(T result, EntityField<? super T> ef, Object value) {
        LOG.tracef("Setting %s::%s field", ef, result.getClass());
        if (ef == null) {
            return false;
        }
        try {
            if (ef.getCollectionElementClass() != Void.class && value instanceof Collection) {
                Class collectionElementClass = ef.getCollectionElementClass();
                ((Collection)value).forEach(v -> ef.collectionAdd(result, CastUtils.cast((Object)v, (Class)collectionElementClass)));
            } else if (ef.getMapKeyClass() != Void.class && value instanceof Map) {
                Class mapKeyClass = ef.getMapKeyClass();
                Class mapValueClass = ef.getMapValueClass();
                ((Map)value).forEach((k, v) -> ef.mapPut(result, CastUtils.cast((Object)k, (Class)mapKeyClass), CastUtils.cast((Object)v, (Class)mapValueClass)));
            } else {
                Object origValue = ef.get(result);
                if (origValue != null) {
                    LOG.warnf("Overwriting value of %s field", (Object)ef.getNameCamelCase());
                }
                ef.set(result, CastUtils.cast((Object)value, (Class)ef.getFieldClass()));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception thrown while setting " + ef + " field", ex);
        }
        return true;
    }

    @Override
    public void add(String name, Object value) {
        EntityField<?> ef = this.nameToEntityField.get(name);
        if (this.topContext && name.equals(SCHEMA_VERSION)) {
            return;
        }
        if (!MapEntityContext.setEntityField(this.result, ef, value)) {
            LOG.warnf("Ignoring field %s", (Object)name);
        }
    }

    @Override
    public Class<T> getScalarType() {
        return this.objectClass;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public BlockContext<?> getContext(String nameOfSubcontext) {
        if (this.topContext && nameOfSubcontext.equals(SCHEMA_VERSION)) {
            if (this.alreadyReadProperty) {
                LOG.warnf("%s must be the first property in the object YAML representation", (Object)SCHEMA_VERSION);
            }
            return null;
        }
        this.alreadyReadProperty = true;
        Supplier<BlockContext<?>> cc = this.contextCreators.get(nameOfSubcontext);
        if (cc != null) {
            return cc.get();
        }
        EntityField<?> ef = this.nameToEntityField.get(nameOfSubcontext);
        if (ef != null) {
            if (ef.getCollectionElementClass() != Void.class) {
                return MapEntityContext.contextFor(ef.getCollectionElementClass(), MapEntitySequenceYamlContext::new, BlockContext.DefaultListContext::new);
            }
            if (ef.getMapValueClass() != Void.class) {
                if (ef.getMapValueClass() == List.class || Collection.class.isAssignableFrom(ef.getMapValueClass())) {
                    return new StringListMapContext();
                }
                return MapEntityContext.contextFor(ef.getMapValueClass(), MapEntityMappingYamlContext::new, BlockContext.DefaultMapContext::new);
            }
            return MapEntityContext.contextFor(ef.getFieldClass(), MapEntityContext::new, BlockContext.DefaultObjectContext::new);
        }
        LOG.warnf("No special context set for field %s", (Object)nameOfSubcontext);
        return null;
    }

    private static <T> BlockContext<?> contextFor(Class<T> clazz, Function<Class<T>, BlockContext<?>> mapContextCreator, Function<Class<T>, BlockContext<?>> defaultCreator) {
        return ModelEntityUtil.entityFieldsKnown(clazz) ? mapContextCreator.apply(clazz) : defaultCreator.apply(clazz);
    }

    @Override
    public void writeValue(T entity, WritingMechanism mech) {
        if (UndefinedValuesUtils.isUndefined(entity)) {
            return;
        }
        mech.writeMapping(() -> {
            if (this.topContext) {
                mech.writePair(SCHEMA_VERSION, () -> mech.writeObject("1.0.Alpha1"));
            }
            TreeSet<String> contextNames = new TreeSet<String>(this.nameToEntityField.keySet());
            contextNames.addAll(this.contextCreators.keySet());
            for (String contextName : contextNames) {
                BlockContext<?> context;
                Object fieldVal;
                EntityField<?> ef = this.nameToEntityField.get(contextName);
                if (ef == null || this.topContext && (ef.getNameCamelCase().equals("id") || ef.getNameCamelCase().equals("realmId")) || (fieldVal = ef.get(entity)) == null || (context = this.getContext(contextName)) == null) continue;
                mech.writePair(contextName, () -> context.writeValue(fieldVal, mech));
            }
        });
    }

    public static class MapEntityMappingYamlContext<T>
    extends BlockContext.DefaultMapContext<T> {
        public MapEntityMappingYamlContext(Class<T> mapValueClass) {
            super(mapValueClass);
        }

        @Override
        public BlockContext<T> getContext(String nameOfSubcontext) {
            return ModelEntityUtil.entityFieldsKnown((Class)this.itemClass) ? new MapEntityContext(this.itemClass, false) : super.getContext(nameOfSubcontext);
        }
    }

    public static class MapEntitySequenceYamlContext<T>
    extends BlockContext.DefaultListContext<T> {
        public MapEntitySequenceYamlContext(Class<T> itemClass) {
            super(itemClass);
        }

        @Override
        public BlockContext<?> getContext(String nameOfSubcontext) {
            return ModelEntityUtil.entityFieldsKnown((Class)this.itemClass) ? new MapEntityContext(this.itemClass, false) : null;
        }

        @Override
        public void add(String name, Object value) {
            if (!(value instanceof AbstractEntity)) {
                throw new IllegalArgumentException("Sequence expected, mapping with " + name + " key found instead.");
            }
            ((AbstractEntity)value).setId(name);
            this.add(value);
        }
    }
}

