/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public abstract class AbstractMultimapKeyValueOperation<T>
extends AbstractKeyValueOperation<T> {
    protected final boolean supportsDuplicates;

    protected AbstractMultimapKeyValueOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat, ClientStatistics clientStatistics, boolean supportsDuplicates) {
        super(requestCode, responseCode, codec, channelFactory, key, keyBytes, cacheName, clientTopology, flags, cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, clientStatistics, null);
        this.supportsDuplicates = supportsDuplicates;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendKeyValueOperation(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (!HotRodConstants.isSuccess(status)) {
            throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status));
        }
        this.complete(null);
    }

    @Override
    protected void sendKeyValueOperation(Channel channel) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + this.keyBytes.length + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + this.value.length + this.codec.estimateSizeMultimapSupportsDuplicated());
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        ByteBufUtil.writeArray(buf, this.value);
        this.codec.writeMultimapSupportDuplicates(buf, this.supportsDuplicates);
        channel.writeAndFlush((Object)buf);
    }
}

