/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AutogeneratedClasses;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;
import org.keycloak.models.map.events.MapAdminEventEntity;
import org.keycloak.models.map.events.MapAuthEventEntity;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntity;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleEntityFields;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class ModelEntityUtil {
    private static final Map<Class<?>, String> MODEL_TO_NAME = new IdentityHashMap();
    private static final Map<String, Class<?>> NAME_TO_MODEL;
    private static final Map<Class<?>, Class<? extends AbstractEntity>> MODEL_TO_ENTITY_TYPE;
    private static final Map<Class<?>, Class<?>> ENTITY_TO_MODEL_TYPE;
    private static final String ID_FIELD_NAME;
    private static final Map<Class<?>, EntityField<?>> ENTITY_TO_ID_FIELD;
    private static final String REALM_ID_FIELD_NAME;
    private static final Map<Class<?>, EntityField<?>> ENTITY_TO_REALM_ID_FIELD;

    public static <V extends AbstractEntity, M> Class<V> getEntityType(Class<M> modelClass) {
        return MODEL_TO_ENTITY_TYPE.get(modelClass);
    }

    public static <V extends AbstractEntity, M> Class<V> getEntityType(Class<M> modelClass, Class<? extends AbstractEntity> defaultClass) {
        return MODEL_TO_ENTITY_TYPE.getOrDefault(modelClass, defaultClass);
    }

    public static <V extends AbstractEntity, M> Class<M> getModelType(Class<V> entityClass) {
        return ENTITY_TO_MODEL_TYPE.get(entityClass);
    }

    public static <V extends AbstractEntity, M> Class<M> getModelType(Class<V> entityClass, Class<M> defaultClass) {
        return ENTITY_TO_MODEL_TYPE.getOrDefault(entityClass, defaultClass);
    }

    public static String getModelName(Class<?> key, String defaultValue) {
        return MODEL_TO_NAME.getOrDefault(key, defaultValue);
    }

    public static String getModelName(Class<?> key) {
        return MODEL_TO_NAME.get(key);
    }

    public static Set<String> getModelNames() {
        return NAME_TO_MODEL.keySet();
    }

    public static <M> Class<M> getModelClass(String key) {
        return NAME_TO_MODEL.get(key);
    }

    public static boolean entityFieldsKnown(Class<?> entityClass) {
        return AutogeneratedClasses.ENTITY_FIELDS.containsKey(entityClass);
    }

    public static <V> Stream<EntityField<V>> getEntityFields(Class<V> entityClass) {
        EntityField<?>[] values = AutogeneratedClasses.ENTITY_FIELDS.get(entityClass);
        return values == null ? Stream.empty() : Stream.of(values);
    }

    public static <V extends AbstractEntity> Optional<EntityField<V>> getEntityField(Class<V> entityClass, String fieldNameCamelCase) {
        Stream<EntityField<V>> s = ModelEntityUtil.getEntityFields(entityClass);
        return s.filter(ef -> fieldNameCamelCase.equals(ef.getNameCamelCase())).findAny();
    }

    public static <V extends AbstractEntity> EntityField<V> getIdField(Class<V> targetEntityClass) {
        return ENTITY_TO_ID_FIELD.get(targetEntityClass);
    }

    public static <V extends AbstractEntity> EntityField<V> getRealmIdField(Class<V> targetEntityClass) {
        return ENTITY_TO_REALM_ID_FIELD.get(targetEntityClass);
    }

    public static <T extends AbstractEntity & UpdatableEntity> T supplyReadOnlyFieldValueIfUnset(T entity, final EntityField<T> entityField, final Object value) {
        if (entity == null || Objects.equals(entityField.get(entity), value)) {
            return entity;
        }
        return DeepCloner.DUMB_CLONER.entityFieldDelegate(entity, new EntityFieldDelegate.WithEntity<T>(entity){

            @Override
            public <EF extends Enum<? extends EntityField<T>>> Object get(EF field) {
                if (field == entityField) {
                    return value;
                }
                return super.get(field);
            }

            @Override
            public <V, EF extends Enum<? extends EntityField<T>>> void set(EF field, V value2) {
                if (field != entityField) {
                    super.set(field, value2);
                }
            }

            @Override
            public String toString() {
                return super.toString() + " [fixed " + entityField + "=" + value + "]";
            }
        });
    }

    static {
        MODEL_TO_NAME.put(SingleUseObjectValueModel.class, "single-use-objects");
        MODEL_TO_NAME.put(ClientScopeModel.class, "client-scopes");
        MODEL_TO_NAME.put(ClientModel.class, "clients");
        MODEL_TO_NAME.put(GroupModel.class, "groups");
        MODEL_TO_NAME.put(RealmModel.class, "realms");
        MODEL_TO_NAME.put(RoleModel.class, "roles");
        MODEL_TO_NAME.put(RootAuthenticationSessionModel.class, "auth-sessions");
        MODEL_TO_NAME.put(UserLoginFailureModel.class, "user-login-failures");
        MODEL_TO_NAME.put(UserModel.class, "users");
        MODEL_TO_NAME.put(UserSessionModel.class, "user-sessions");
        MODEL_TO_NAME.put(PermissionTicket.class, "authz-permission-tickets");
        MODEL_TO_NAME.put(Policy.class, "authz-policies");
        MODEL_TO_NAME.put(ResourceServer.class, "authz-resource-servers");
        MODEL_TO_NAME.put(Resource.class, "authz-resources");
        MODEL_TO_NAME.put(Scope.class, "authz-scopes");
        MODEL_TO_NAME.put(AdminEvent.class, "admin-events");
        MODEL_TO_NAME.put(Event.class, "auth-events");
        NAME_TO_MODEL = MODEL_TO_NAME.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getValue, Map.Entry::getKey));
        MODEL_TO_ENTITY_TYPE = new IdentityHashMap();
        MODEL_TO_ENTITY_TYPE.put(SingleUseObjectValueModel.class, MapSingleUseObjectEntity.class);
        MODEL_TO_ENTITY_TYPE.put(ClientScopeModel.class, MapClientScopeEntity.class);
        MODEL_TO_ENTITY_TYPE.put(ClientModel.class, MapClientEntity.class);
        MODEL_TO_ENTITY_TYPE.put(GroupModel.class, MapGroupEntity.class);
        MODEL_TO_ENTITY_TYPE.put(RealmModel.class, MapRealmEntity.class);
        MODEL_TO_ENTITY_TYPE.put(RoleModel.class, MapRoleEntity.class);
        MODEL_TO_ENTITY_TYPE.put(RootAuthenticationSessionModel.class, MapRootAuthenticationSessionEntity.class);
        MODEL_TO_ENTITY_TYPE.put(UserLoginFailureModel.class, MapUserLoginFailureEntity.class);
        MODEL_TO_ENTITY_TYPE.put(UserModel.class, MapUserEntity.class);
        MODEL_TO_ENTITY_TYPE.put(UserSessionModel.class, MapUserSessionEntity.class);
        MODEL_TO_ENTITY_TYPE.put(AuthenticatedClientSessionModel.class, MapAuthenticatedClientSessionEntity.class);
        MODEL_TO_ENTITY_TYPE.put(PermissionTicket.class, MapPermissionTicketEntity.class);
        MODEL_TO_ENTITY_TYPE.put(Policy.class, MapPolicyEntity.class);
        MODEL_TO_ENTITY_TYPE.put(ResourceServer.class, MapResourceServerEntity.class);
        MODEL_TO_ENTITY_TYPE.put(Resource.class, MapResourceEntity.class);
        MODEL_TO_ENTITY_TYPE.put(Scope.class, MapScopeEntity.class);
        MODEL_TO_ENTITY_TYPE.put(AdminEvent.class, MapAdminEventEntity.class);
        MODEL_TO_ENTITY_TYPE.put(Event.class, MapAuthEventEntity.class);
        ENTITY_TO_MODEL_TYPE = MODEL_TO_ENTITY_TYPE.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getValue, Map.Entry::getKey));
        ID_FIELD_NAME = MapRoleEntityFields.ID.getName();
        ENTITY_TO_ID_FIELD = AutogeneratedClasses.ENTITY_FIELDS.entrySet().stream().filter(me -> Stream.of((EntityField[])me.getValue()).anyMatch(e -> ID_FIELD_NAME.equals(e.getName()))).map(me -> Map.entry((Class)me.getKey(), Stream.of((EntityField[])me.getValue()).filter(e -> ID_FIELD_NAME.equals(e.getName())).findAny().orElse(null))).filter(me -> me.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        REALM_ID_FIELD_NAME = MapRoleEntityFields.REALM_ID.getName();
        ENTITY_TO_REALM_ID_FIELD = AutogeneratedClasses.ENTITY_FIELDS.entrySet().stream().filter(me -> Stream.of((EntityField[])me.getValue()).anyMatch(e -> REALM_ID_FIELD_NAME.equals(e.getName()))).map(me -> Map.entry((Class)me.getKey(), Stream.of((EntityField[])me.getValue()).filter(e -> REALM_ID_FIELD_NAME.equals(e.getName())).findAny().orElse(null))).filter(me -> me.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

